/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.streaming;

import com.qiniu.common.QiniuException;
import com.qiniu.http.Client;
import com.qiniu.http.Response;
import com.qiniu.streaming.model.ActivityRecords;
import com.qiniu.streaming.model.StreamAttribute;
import com.qiniu.streaming.model.StreamListing;
import com.qiniu.streaming.model.StreamStatus;
import com.qiniu.util.Auth;
import com.qiniu.util.StringMap;
import com.qiniu.util.StringUtils;
import com.qiniu.util.UrlSafeBase64;
import java.util.Iterator;

public final class StreamingManager {
    private final String apiServer;
    private final String hub;
    private final Client client;
    private final Auth auth;

    public StreamingManager(Auth auth, String hub) {
        this(auth, hub, "http://pili.qiniuapi.com");
    }

    StreamingManager(Auth auth, String hub, String server) {
        this.apiServer = server;
        this.hub = hub;
        this.auth = auth;
        this.client = new Client(null, false, null, 10, 30, 0);
    }

    public void create(String key) throws QiniuException {
        String path = "";
        String body = String.format("{\"key\":\"%s\"}", key);
        this.post(path, body, null);
    }

    public StreamAttribute attribute(String key) throws QiniuException {
        String path = this.encodeKey(key);
        return this.get(path, StreamAttribute.class);
    }

    public ListIterator createStreamListIterator(boolean live, String prefix) {
        return new ListIterator(live, prefix);
    }

    public StreamListing listStreams(boolean live, String prefix, String marker) throws QiniuException {
        StringMap map = new StringMap();
        if (live) {
            map.put("liveonly", live);
        }
        if (!StringUtils.isNullOrEmpty(prefix)) {
            map.put("prefix", prefix);
        }
        if (!StringUtils.isNullOrEmpty(marker)) {
            map.put("marker", marker);
        }
        String path = "";
        if (map.size() != 0) {
            path = path + "?" + map.formString();
        }
        return this.get(path, StreamListing.class);
    }

    public void disableTill(String key, long epoch) throws QiniuException {
        String path = this.encodeKey(key) + "/disabled";
        String body = String.format("{\"disabledTill\":%d}", epoch);
        this.post(path, body, null);
    }

    public void enable(String key) throws QiniuException {
        this.disableTill(key, 0L);
    }

    public StreamStatus status(String key) throws QiniuException {
        String path = this.encodeKey(key) + "/live";
        return this.get(path, StreamStatus.class);
    }

    public String saveAs(String key, String fileName) throws QiniuException {
        return this.saveAs(key, fileName, 0L, 0L);
    }

    public String saveAs(String key, String fileName, long start, long end) throws QiniuException {
        String path = this.encodeKey(key) + "/saveas";
        String body = fileName == null ? String.format("{\"start\": %d,\"end\": %d}", start, end) : String.format("{\"fname\": %s,\"start\": %d,\"end\": %d}", fileName, start, end);
        SaveRet r = this.post(path, body, SaveRet.class);
        return r.fname;
    }

    public ActivityRecords history(String key, long start, long end) throws QiniuException {
        if (start <= 0L || end < 0L || start >= end && end != 0L) {
            throw new QiniuException(new IllegalArgumentException("bad argument" + start + "," + end));
        }
        String path = this.encodeKey(key) + "/historyactivity?" + start;
        if (end != 0L) {
            path = path + "&end=" + end;
        }
        return this.get(path, ActivityRecords.class);
    }

    private String encodeKey(String key) {
        return "/" + UrlSafeBase64.encodeToString(key);
    }

    private <T> T get(String path, Class<T> classOfT) throws QiniuException {
        String url = this.apiServer + "/v2/hubs/" + this.hub + "/streams" + path;
        StringMap headers = this.auth.authorizationV2(url);
        Response r = this.client.get(url, headers);
        if (classOfT != null) {
            return r.jsonToObject(classOfT);
        }
        return null;
    }

    private <T> T post(String path, String body, Class<T> classOfT) throws QiniuException {
        String url = this.apiServer + "/v2/hubs/" + this.hub + "/streams" + path;
        byte[] b = body.getBytes();
        StringMap headers = this.auth.authorizationV2(url, "POST", b, "application/json");
        Response r = this.client.post(url, b, headers, "application/json");
        if (classOfT != null) {
            return r.jsonToObject(classOfT);
        }
        return null;
    }

    public class ListIterator
    implements Iterator<String[]> {
        private final boolean live;
        private String marker = null;
        private String prefix;
        private QiniuException exception = null;

        public ListIterator(boolean live, String prefix) {
            this.live = live;
            this.prefix = prefix;
        }

        public QiniuException exception() {
            return this.exception;
        }

        @Override
        public boolean hasNext() {
            return this.exception == null && !"".equals(this.marker);
        }

        @Override
        public String[] next() {
            try {
                StreamListing l = StreamingManager.this.listStreams(this.live, this.prefix, this.marker);
                this.marker = l.marker == null ? "" : l.marker;
                return l.keys();
            }
            catch (QiniuException e) {
                this.exception = e;
                return null;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }

    private static class SaveRet {
        public String fname;

        private SaveRet() {
        }
    }
}

