// Copyright 2021 Tencent Inc. All rights reserved.
//
// 微信支付分停车服务
//
// 微信支付分停车服务 扣费API
//
// API version: 1.2.1

// Code generated by WechatPay APIv3 Generator based on [OpenAPI
// Generator](https://openapi-generator.tech); DO NOT EDIT.

package com.wechat.pay.java.service.wexinpayscoreparking.model;

import static com.wechat.pay.java.core.util.StringUtil.toIndentedString;

import com.google.gson.annotations.SerializedName;
import java.util.List;

/** Transaction */
public class Transaction {
  /** 公众账号id 说明：appid是商户在微信申请公众号或移动应用成功后分配的帐号ID，登录平台为mp.weixin.qq.com或open.weixin.qq.com */
  @SerializedName("appid")
  private String appid;

  /** 子商户公众账号id 说明：子商户申请的公众号或移动应用appid，需要在服务商的商户平台为子商户绑定 */
  @SerializedName("sub_appid")
  private String subAppid;

  /** 商户号 说明：微信支付分配的商户号 */
  @SerializedName("sp_mchid")
  private String spMchid;

  /** 子商户号 说明：微信支付分配的子商户号 */
  @SerializedName("sub_mchid")
  private String subMchid;

  /** 服务描述 说明：商户自定义字段，用于交易账单中对扣费服务的描述。 */
  @SerializedName("description")
  private String description;

  /**
   * 订单创建时间
   * 说明：订单成功创建时返回，遵循[rfc3339](https://datatracker.ietf.org/doc/html/rfc3339)标准格式，格式为yyyy-MM-DDTHH:mm:ss+TIMEZONE，yyyy-MM-DD表示年月日，T出现在字符串中，表示time元素的开头，HH:mm:ss表示时分秒，TIMEZONE表示时区（+08:00表示东八区时间，领先UTC
   * 8小时，即北京时间）。例如：2015-05-20T13:29:35+08:00表示，北京时间2015年5月20日 13点29分35秒。
   */
  @SerializedName("create_time")
  private String createTime;

  /** 商户订单号 说明：商户系统内部订单号，只能是数字、大小写字母_-*且在同一个商户号下唯一 */
  @SerializedName("out_trade_no")
  private String outTradeNo;

  /** 微信支付订单号 说明：微信支付订单号 */
  @SerializedName("transaction_id")
  private String transactionId;

  /** 交易状态 说明：SUCCESS—支付成功 ACCEPTED—已接收，等待扣款 PAY_FAIL–支付失败(其他原因，如银行返回失败) REFUND—转入退款 */
  @SerializedName("trade_state")
  private String tradeState;

  /** 交易状态描述 说明：对当前订单状态的描述和下一步操作的指引 */
  @SerializedName("trade_state_description")
  private String tradeStateDescription;

  /**
   * 支付完成时间
   * 说明：订单支付完成时间，遵循[rfc3339](https://datatracker.ietf.org/doc/html/rfc3339)标准格式，格式为yyyy-MM-DDTHH:mm:ss+TIMEZONE，yyyy-MM-DD表示年月日，T出现在字符串中，表示time元素的开头，HH:mm:ss表示时分秒，TIMEZONE表示时区（+08:00表示东八区时间，领先UTC
   * 8小时，即北京时间）。例如：2015-05-20T13:29:35+08:00表示，北京时间2015年5月20日 13点29分35秒。
   */
  @SerializedName("success_time")
  private String successTime;

  /** 付款银行 说明：银行类型，采用字符串类型的银行标识。BPA：该笔订单由微信进行垫付 */
  @SerializedName("bank_type")
  private String bankType;

  /** 用户是否已还款 说明：枚举值： Y：用户已还款 N：用户未还款 注意：使用此字段前需先确认bank_type字段值为BPA以及 trade_state字段值为SUCCESS。 */
  @SerializedName("user_repaid")
  private String userRepaid;

  /** 附加数据 说明：附加数据，在查询API和支付通知中原样返回，可作为自定义参数使用 */
  @SerializedName("attach")
  private String attach;

  /** 交易场景 说明：交易场景值，目前支持 ：PARKING：车场停车场景 */
  @SerializedName("trade_scene")
  private String tradeScene;

  /** 停车场景信息 说明：返回信息中的trade_scene为PARKING，返回该场景信息 */
  @SerializedName("parking_info")
  private ParkingTradeScene parkingInfo;

  /** 支付者信息 说明：支付者信息 */
  @SerializedName("payer")
  private Payer payer;

  /** 订单金额信息 说明：订单金额信息 */
  @SerializedName("amount")
  private QueryOrderAmount amount;

  /** 优惠信息 说明：优惠信息 */
  @SerializedName("promotion_detail")
  private List<PromotionDetail> promotionDetail;

  public String getAppid() {
    return appid;
  }

  public void setAppid(String appid) {
    this.appid = appid;
  }

  public String getSubAppid() {
    return subAppid;
  }

  public void setSubAppid(String subAppid) {
    this.subAppid = subAppid;
  }

  public String getSpMchid() {
    return spMchid;
  }

  public void setSpMchid(String spMchid) {
    this.spMchid = spMchid;
  }

  public String getSubMchid() {
    return subMchid;
  }

  public void setSubMchid(String subMchid) {
    this.subMchid = subMchid;
  }

  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public String getCreateTime() {
    return createTime;
  }

  public void setCreateTime(String createTime) {
    this.createTime = createTime;
  }

  public String getOutTradeNo() {
    return outTradeNo;
  }

  public void setOutTradeNo(String outTradeNo) {
    this.outTradeNo = outTradeNo;
  }

  public String getTransactionId() {
    return transactionId;
  }

  public void setTransactionId(String transactionId) {
    this.transactionId = transactionId;
  }

  public String getTradeState() {
    return tradeState;
  }

  public void setTradeState(String tradeState) {
    this.tradeState = tradeState;
  }

  public String getTradeStateDescription() {
    return tradeStateDescription;
  }

  public void setTradeStateDescription(String tradeStateDescription) {
    this.tradeStateDescription = tradeStateDescription;
  }

  public String getSuccessTime() {
    return successTime;
  }

  public void setSuccessTime(String successTime) {
    this.successTime = successTime;
  }

  public String getBankType() {
    return bankType;
  }

  public void setBankType(String bankType) {
    this.bankType = bankType;
  }

  public String getUserRepaid() {
    return userRepaid;
  }

  public void setUserRepaid(String userRepaid) {
    this.userRepaid = userRepaid;
  }

  public String getAttach() {
    return attach;
  }

  public void setAttach(String attach) {
    this.attach = attach;
  }

  public String getTradeScene() {
    return tradeScene;
  }

  public void setTradeScene(String tradeScene) {
    this.tradeScene = tradeScene;
  }

  public ParkingTradeScene getParkingInfo() {
    return parkingInfo;
  }

  public void setParkingInfo(ParkingTradeScene parkingInfo) {
    this.parkingInfo = parkingInfo;
  }

  public Payer getPayer() {
    return payer;
  }

  public void setPayer(Payer payer) {
    this.payer = payer;
  }

  public QueryOrderAmount getAmount() {
    return amount;
  }

  public void setAmount(QueryOrderAmount amount) {
    this.amount = amount;
  }

  public List<PromotionDetail> getPromotionDetail() {
    return promotionDetail;
  }

  public void setPromotionDetail(List<PromotionDetail> promotionDetail) {
    this.promotionDetail = promotionDetail;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Transaction {\n");
    sb.append("    appid: ").append(toIndentedString(appid)).append("\n");
    sb.append("    subAppid: ").append(toIndentedString(subAppid)).append("\n");
    sb.append("    spMchid: ").append(toIndentedString(spMchid)).append("\n");
    sb.append("    subMchid: ").append(toIndentedString(subMchid)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
    sb.append("    outTradeNo: ").append(toIndentedString(outTradeNo)).append("\n");
    sb.append("    transactionId: ").append(toIndentedString(transactionId)).append("\n");
    sb.append("    tradeState: ").append(toIndentedString(tradeState)).append("\n");
    sb.append("    tradeStateDescription: ")
        .append(toIndentedString(tradeStateDescription))
        .append("\n");
    sb.append("    successTime: ").append(toIndentedString(successTime)).append("\n");
    sb.append("    bankType: ").append(toIndentedString(bankType)).append("\n");
    sb.append("    userRepaid: ").append(toIndentedString(userRepaid)).append("\n");
    sb.append("    attach: ").append(toIndentedString(attach)).append("\n");
    sb.append("    tradeScene: ").append(toIndentedString(tradeScene)).append("\n");
    sb.append("    parkingInfo: ").append(toIndentedString(parkingInfo)).append("\n");
    sb.append("    payer: ").append(toIndentedString(payer)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    promotionDetail: ").append(toIndentedString(promotionDetail)).append("\n");
    sb.append("}");
    return sb.toString();
  }
}
