// Copyright 2021 Tencent Inc. All rights reserved.
//
// 微信支付分停车服务
//
// 微信支付分停车服务 扣费API
//
// API version: 1.2.1

// Code generated by WechatPay APIv3 Generator based on [OpenAPI
// Generator](https://openapi-generator.tech); DO NOT EDIT.

package com.wechat.pay.java.service.wexinpayscoreparking.model;

import static com.wechat.pay.java.core.util.StringUtil.toIndentedString;

import com.google.gson.annotations.SerializedName;

/** CreateParkingRequest */
public class CreateParkingRequest {
  /** 子商户号 说明：微信支付分配的子商户号，服务商模式下必传 */
  @SerializedName("sub_mchid")
  private String subMchid;

  /** 商户入场id 说明：商户侧入场标识id，在同一个商户号下唯一 */
  @SerializedName("out_parking_no")
  private String outParkingNo;

  /** 车牌号 说明：车牌号，仅包括省份+车牌，不包括特殊字符。 */
  @SerializedName("plate_number")
  private String plateNumber;

  /** 车牌颜色 说明：车牌颜色 */
  @SerializedName("plate_color")
  private PlateColor plateColor;

  /** 回调通知url 说明：接受入场状态变更回调通知的url，注意回调url只接受https */
  @SerializedName("notify_url")
  private String notifyUrl;

  /**
   * 入场时间
   * 说明：入场时间，遵循[rfc3339](https://datatracker.ietf.org/doc/html/rfc3339)标准格式，格式为yyyy-MM-DDTHH:mm:ss+TIMEZONE，yyyy-MM-DD表示年月日，T出现在字符串中，表示time元素的开头，HH:mm:ss表示时分秒，TIMEZONE表示时区（+08:00表示东八区时间，领先UTC
   * 8小时，即北京时间）。例如：2015-05-20T13:29:35+08:00表示，北京时间2015年5月20日 13点29分35秒。
   */
  @SerializedName("start_time")
  private String startTime;

  /** 停车场名称 说明：所在停车位车场的名称 */
  @SerializedName("parking_name")
  private String parkingName;

  /** 免费时长 说明：停车场的免费停车时长，单位为秒 */
  @SerializedName("free_duration")
  private Integer freeDuration;

  public String getSubMchid() {
    return subMchid;
  }

  public void setSubMchid(String subMchid) {
    this.subMchid = subMchid;
  }

  public String getOutParkingNo() {
    return outParkingNo;
  }

  public void setOutParkingNo(String outParkingNo) {
    this.outParkingNo = outParkingNo;
  }

  public String getPlateNumber() {
    return plateNumber;
  }

  public void setPlateNumber(String plateNumber) {
    this.plateNumber = plateNumber;
  }

  public PlateColor getPlateColor() {
    return plateColor;
  }

  public void setPlateColor(PlateColor plateColor) {
    this.plateColor = plateColor;
  }

  public String getNotifyUrl() {
    return notifyUrl;
  }

  public void setNotifyUrl(String notifyUrl) {
    this.notifyUrl = notifyUrl;
  }

  public String getStartTime() {
    return startTime;
  }

  public void setStartTime(String startTime) {
    this.startTime = startTime;
  }

  public String getParkingName() {
    return parkingName;
  }

  public void setParkingName(String parkingName) {
    this.parkingName = parkingName;
  }

  public Integer getFreeDuration() {
    return freeDuration;
  }

  public void setFreeDuration(Integer freeDuration) {
    this.freeDuration = freeDuration;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreateParkingRequest {\n");
    sb.append("    subMchid: ").append(toIndentedString(subMchid)).append("\n");
    sb.append("    outParkingNo: ").append(toIndentedString(outParkingNo)).append("\n");
    sb.append("    plateNumber: ").append(toIndentedString(plateNumber)).append("\n");
    sb.append("    plateColor: ").append(toIndentedString(plateColor)).append("\n");
    sb.append("    notifyUrl: ").append(toIndentedString(notifyUrl)).append("\n");
    sb.append("    startTime: ").append(toIndentedString(startTime)).append("\n");
    sb.append("    parkingName: ").append(toIndentedString(parkingName)).append("\n");
    sb.append("    freeDuration: ").append(toIndentedString(freeDuration)).append("\n");
    sb.append("}");
    return sb.toString();
  }
}
