// Copyright 2021 Tencent Inc. All rights reserved.
//
// 商家转账对外API
//
// * 场景及业务流程：     商户可通过该产品实现同时向多个用户微信零钱进行转账的操作，可用于发放奖金补贴、佣金货款结算、员工报销等场景。
// [https://pay.weixin.qq.com/index.php/public/product/detail?pid=108&productType=0](https://pay.weixin.qq.com/index.php/public/product/detail?pid=108&productType=0) * 接入步骤：     * 商户在微信支付商户平台开通“批量转账到零钱”产品权限，并勾选“使用API方式发起转账”。     * 调用批量转账接口，对多个用户微信零钱发起转账。     * 调用查询批次接口，可获取到转账批次详情及当前状态。     * 调用查询明细接口，可获取到单条转账明细详情及当前状态。
//
// API version: 1.0.5

// Code generated by WechatPay APIv3 Generator based on [OpenAPI
// Generator](https://openapi-generator.tech); DO NOT EDIT.

package com.wechat.pay.java.service.transferbatch.model;

import static com.wechat.pay.java.core.util.StringUtil.toIndentedString;

import com.google.gson.annotations.SerializedName;

/** TransferBatchGet */
public class TransferBatchGet {
  /** 商户号 说明：微信支付分配的商户号 */
  @SerializedName("mchid")
  private String mchid;

  /** 商家批次单号 说明：商户系统内部的商家批次单号，在商户系统内部唯一 */
  @SerializedName("out_batch_no")
  private String outBatchNo;

  /** 微信批次单号 说明：微信批次单号，微信商家转账系统返回的唯一标识 */
  @SerializedName("batch_id")
  private String batchId;

  /** 商户appid 说明：申请商户号的appid或商户号绑定的appid（企业号corpid即为此appid） */
  @SerializedName("appid")
  private String appid;

  /**
   * 批次状态 说明：WAIT_PAY: 待付款确认。需要付款出资商户在商家助手小程序或服务商助手小程序进行付款确认
   * ACCEPTED:已受理。批次已受理成功，若发起批量转账的30分钟后，转账批次单仍处于该状态，可能原因是商户账户余额不足等。商户可查询账户资金流水，若该笔转账批次单的扣款已经发生，则表示批次已经进入转账中，请再次查单确认
   * PROCESSING:转账中。已开始处理批次内的转账明细单 FINISHED:已完成。批次内的所有转账明细单都已处理完成 CLOSED:已关闭。可查询具体的批次关闭原因确认
   */
  @SerializedName("batch_status")
  private String batchStatus;

  /** 批次类型 说明：API:API方式发起 WEB:页面方式发起 */
  @SerializedName("batch_type")
  private String batchType;

  /** 批次名称 说明：该笔批量转账的名称 */
  @SerializedName("batch_name")
  private String batchName;

  /** 批次备注 说明：转账说明，UTF8编码，最多允许32个字符 */
  @SerializedName("batch_remark")
  private String batchRemark;

  /** 批次关闭原因 说明：如果批次单状态为“CLOSED”（已关闭），则有关闭原因 */
  @SerializedName("close_reason")
  private CloseReasonType closeReason;

  /** 转账总金额 说明：转账金额单位为“分” */
  @SerializedName("total_amount")
  private Long totalAmount;

  /** 转账总笔数 说明：一个转账批次单最多发起三千笔转账 */
  @SerializedName("total_num")
  private Integer totalNum;

  /** 批次创建时间 说明：批次受理成功时返回，按照使用rfc3339所定义的格式，格式为YYYY-MM-DDThh:mm:ss+TIMEZONE */
  @SerializedName("create_time")
  private String createTime;

  /** 批次更新时间 说明：批次最近一次状态变更的时间，按照使用rfc3339所定义的格式，格式为YYYY-MM-DDThh:mm:ss+TIMEZONE */
  @SerializedName("update_time")
  private String updateTime;

  /** 转账成功金额 说明：转账成功的金额，单位为“分”。当批次状态为“PROCESSING”（转账中）时，转账成功金额随时可能变化 */
  @SerializedName("success_amount")
  private Long successAmount;

  /** 转账成功笔数 说明：转账成功的笔数。当批次状态为“PROCESSING”（转账中）时，转账成功笔数随时可能变化 */
  @SerializedName("success_num")
  private Integer successNum;

  /** 转账失败金额 说明：转账失败的金额，单位为“分” */
  @SerializedName("fail_amount")
  private Long failAmount;

  /** 转账失败笔数 说明：转账失败的笔数 */
  @SerializedName("fail_num")
  private Integer failNum;

  /** 转账场景ID 说明：指定的转账场景ID */
  @SerializedName("transfer_scene_id")
  private String transferSceneId;

  public String getMchid() {
    return mchid;
  }

  public void setMchid(String mchid) {
    this.mchid = mchid;
  }

  public String getOutBatchNo() {
    return outBatchNo;
  }

  public void setOutBatchNo(String outBatchNo) {
    this.outBatchNo = outBatchNo;
  }

  public String getBatchId() {
    return batchId;
  }

  public void setBatchId(String batchId) {
    this.batchId = batchId;
  }

  public String getAppid() {
    return appid;
  }

  public void setAppid(String appid) {
    this.appid = appid;
  }

  public String getBatchStatus() {
    return batchStatus;
  }

  public void setBatchStatus(String batchStatus) {
    this.batchStatus = batchStatus;
  }

  public String getBatchType() {
    return batchType;
  }

  public void setBatchType(String batchType) {
    this.batchType = batchType;
  }

  public String getBatchName() {
    return batchName;
  }

  public void setBatchName(String batchName) {
    this.batchName = batchName;
  }

  public String getBatchRemark() {
    return batchRemark;
  }

  public void setBatchRemark(String batchRemark) {
    this.batchRemark = batchRemark;
  }

  public CloseReasonType getCloseReason() {
    return closeReason;
  }

  public void setCloseReason(CloseReasonType closeReason) {
    this.closeReason = closeReason;
  }

  public Long getTotalAmount() {
    return totalAmount;
  }

  public void setTotalAmount(Long totalAmount) {
    this.totalAmount = totalAmount;
  }

  public Integer getTotalNum() {
    return totalNum;
  }

  public void setTotalNum(Integer totalNum) {
    this.totalNum = totalNum;
  }

  public String getCreateTime() {
    return createTime;
  }

  public void setCreateTime(String createTime) {
    this.createTime = createTime;
  }

  public String getUpdateTime() {
    return updateTime;
  }

  public void setUpdateTime(String updateTime) {
    this.updateTime = updateTime;
  }

  public Long getSuccessAmount() {
    return successAmount;
  }

  public void setSuccessAmount(Long successAmount) {
    this.successAmount = successAmount;
  }

  public Integer getSuccessNum() {
    return successNum;
  }

  public void setSuccessNum(Integer successNum) {
    this.successNum = successNum;
  }

  public Long getFailAmount() {
    return failAmount;
  }

  public void setFailAmount(Long failAmount) {
    this.failAmount = failAmount;
  }

  public Integer getFailNum() {
    return failNum;
  }

  public void setFailNum(Integer failNum) {
    this.failNum = failNum;
  }

  public String getTransferSceneId() {
    return transferSceneId;
  }

  public void setTransferSceneId(String transferSceneId) {
    this.transferSceneId = transferSceneId;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TransferBatchGet {\n");
    sb.append("    mchid: ").append(toIndentedString(mchid)).append("\n");
    sb.append("    outBatchNo: ").append(toIndentedString(outBatchNo)).append("\n");
    sb.append("    batchId: ").append(toIndentedString(batchId)).append("\n");
    sb.append("    appid: ").append(toIndentedString(appid)).append("\n");
    sb.append("    batchStatus: ").append(toIndentedString(batchStatus)).append("\n");
    sb.append("    batchType: ").append(toIndentedString(batchType)).append("\n");
    sb.append("    batchName: ").append(toIndentedString(batchName)).append("\n");
    sb.append("    batchRemark: ").append(toIndentedString(batchRemark)).append("\n");
    sb.append("    closeReason: ").append(toIndentedString(closeReason)).append("\n");
    sb.append("    totalAmount: ").append(toIndentedString(totalAmount)).append("\n");
    sb.append("    totalNum: ").append(toIndentedString(totalNum)).append("\n");
    sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
    sb.append("    updateTime: ").append(toIndentedString(updateTime)).append("\n");
    sb.append("    successAmount: ").append(toIndentedString(successAmount)).append("\n");
    sb.append("    successNum: ").append(toIndentedString(successNum)).append("\n");
    sb.append("    failAmount: ").append(toIndentedString(failAmount)).append("\n");
    sb.append("    failNum: ").append(toIndentedString(failNum)).append("\n");
    sb.append("    transferSceneId: ").append(toIndentedString(transferSceneId)).append("\n");
    sb.append("}");
    return sb.toString();
  }
}
