// Copyright 2021 Tencent Inc. All rights reserved.
//
// 微信支付电商平台分账API
//
// 微信支付电商平台分账API
//
// API version: 1.0.21

// Code generated by WechatPay APIv3 Generator based on [OpenAPI
// Generator](https://openapi-generator.tech); DO NOT EDIT.

package com.wechat.pay.java.service.ecommerceprofitsharing.model;

import static com.wechat.pay.java.core.util.StringUtil.toIndentedString;

import com.google.gson.annotations.SerializedName;
import com.wechat.pay.java.core.cipher.Encryption;
import java.util.function.UnaryOperator;

/** CreateOrderReceiver */
public class CreateOrderReceiver {
  /** 分账接收方类型 说明：分账接收方类型 枚举值： MERCHANT\\_ID：商户 PERSONAL\\_OPENID：个人 */
  @SerializedName("type")
  private String type;

  /** 分账接收方账号 说明：分账接收方账号： 类型是MERCHANT\\_ID时，是商户ID 类型是PERSONAL\\_OPENID时，是个人OpenID */
  @SerializedName("receiver_account")
  private String receiverAccount;

  /** 分账接收商户号 说明：接收方类型为MERCHANT_ID时，填入微信支付分配的商户号。 如果填写了字段receiver_account，则无需填写本字段 */
  @SerializedName("receiver_mchid")
  private String receiverMchid;

  /** 分账金额 说明：分账金额，单位为分，只能为整数，不能超过原订单支付金额及最大分账比例金额 */
  @SerializedName("amount")
  private Long amount;

  /** 分账描述 说明：分账的原因描述，分账账单中需要体现 */
  @SerializedName("description")
  private String description;

  /**
   * 分账个人接收方姓名 说明：可选项，在接收方类型为个人的时可选填，若有值，会检查与 receiver\\_name 是否实名匹配，不匹配会拒绝分账请求 1.
   * 分账接收方类型是PERSONAL\\_OPENID时，是个人姓名的密文（选传，传则校验）此字段的加密的方式详见：[敏感信息加解密](https://pay.weixin.qq.com/wiki/doc/apiv3_partner/wechatpay/wechatpay4_3.shtml)
   * 2. 使用微信支付平台证书中的公钥 3. 使用RSAES-OAEP算法进行加密 4. 将请求中HTTP头部的Wechatpay-Serial设置为证书序列号
   */
  @Encryption
  @SerializedName("receiver_name")
  private String receiverName;

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public String getReceiverAccount() {
    return receiverAccount;
  }

  public void setReceiverAccount(String receiverAccount) {
    this.receiverAccount = receiverAccount;
  }

  public String getReceiverMchid() {
    return receiverMchid;
  }

  public void setReceiverMchid(String receiverMchid) {
    this.receiverMchid = receiverMchid;
  }

  public Long getAmount() {
    return amount;
  }

  public void setAmount(Long amount) {
    this.amount = amount;
  }

  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public String getReceiverName() {
    return receiverName;
  }

  public void setReceiverName(String receiverName) {
    this.receiverName = receiverName;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreateOrderReceiver {\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    receiverAccount: ").append(toIndentedString(receiverAccount)).append("\n");
    sb.append("    receiverMchid: ").append(toIndentedString(receiverMchid)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    receiverName: ").append(toIndentedString(receiverName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  public CreateOrderReceiver cloneWithCipher(UnaryOperator<String> s) {
    CreateOrderReceiver copy = new CreateOrderReceiver();
    copy.type = type;
    copy.receiverAccount = receiverAccount;
    copy.receiverMchid = receiverMchid;
    copy.amount = amount;
    copy.description = description;
    if (receiverName != null && !receiverName.isEmpty()) {
      copy.receiverName = s.apply(receiverName);
    }
    return copy;
  }
}
