// Copyright 2021 Tencent Inc. All rights reserved.
//
// 微信支付营销系统开放API
//
// 新增立减金api
//
// API version: 3.4.0

// Code generated by WechatPay APIv3 Generator based on [OpenAPI
// Generator](https://openapi-generator.tech); DO NOT EDIT.

package com.wechat.pay.java.service.cashcoupons;

import static com.wechat.pay.java.core.http.UrlEncoder.urlEncode;
import static com.wechat.pay.java.core.util.GsonUtil.toJson;
import static java.util.Objects.requireNonNull;

import com.wechat.pay.java.core.Config;
import com.wechat.pay.java.core.exception.HttpException;
import com.wechat.pay.java.core.exception.MalformedMessageException;
import com.wechat.pay.java.core.exception.ServiceException;
import com.wechat.pay.java.core.exception.ValidationException;
import com.wechat.pay.java.core.http.Constant;
import com.wechat.pay.java.core.http.DefaultHttpClientBuilder;
import com.wechat.pay.java.core.http.HostName;
import com.wechat.pay.java.core.http.HttpClient;
import com.wechat.pay.java.core.http.HttpHeaders;
import com.wechat.pay.java.core.http.HttpMethod;
import com.wechat.pay.java.core.http.HttpRequest;
import com.wechat.pay.java.core.http.HttpResponse;
import com.wechat.pay.java.core.http.JsonRequestBody;
import com.wechat.pay.java.core.http.MediaType;
import com.wechat.pay.java.core.http.QueryParameter;
import com.wechat.pay.java.core.http.RequestBody;
import com.wechat.pay.java.service.cashcoupons.model.AvailableMerchantCollection;
import com.wechat.pay.java.service.cashcoupons.model.AvailableSingleitemCollection;
import com.wechat.pay.java.service.cashcoupons.model.Callback;
import com.wechat.pay.java.service.cashcoupons.model.Coupon;
import com.wechat.pay.java.service.cashcoupons.model.CouponCollection;
import com.wechat.pay.java.service.cashcoupons.model.CreateCouponStockRequest;
import com.wechat.pay.java.service.cashcoupons.model.CreateCouponStockResponse;
import com.wechat.pay.java.service.cashcoupons.model.ListAvailableMerchantsRequest;
import com.wechat.pay.java.service.cashcoupons.model.ListAvailableSingleitemsRequest;
import com.wechat.pay.java.service.cashcoupons.model.ListCouponsByFilterRequest;
import com.wechat.pay.java.service.cashcoupons.model.ListStocksRequest;
import com.wechat.pay.java.service.cashcoupons.model.PauseStockRequest;
import com.wechat.pay.java.service.cashcoupons.model.PauseStockResponse;
import com.wechat.pay.java.service.cashcoupons.model.QueryCallbackRequest;
import com.wechat.pay.java.service.cashcoupons.model.QueryCouponRequest;
import com.wechat.pay.java.service.cashcoupons.model.QueryStockRequest;
import com.wechat.pay.java.service.cashcoupons.model.RefundFlowRequest;
import com.wechat.pay.java.service.cashcoupons.model.RefundFlowResponse;
import com.wechat.pay.java.service.cashcoupons.model.RestartStockRequest;
import com.wechat.pay.java.service.cashcoupons.model.RestartStockResponse;
import com.wechat.pay.java.service.cashcoupons.model.SendCouponRequest;
import com.wechat.pay.java.service.cashcoupons.model.SendCouponResponse;
import com.wechat.pay.java.service.cashcoupons.model.SetCallbackRequest;
import com.wechat.pay.java.service.cashcoupons.model.SetCallbackResponse;
import com.wechat.pay.java.service.cashcoupons.model.StartStockRequest;
import com.wechat.pay.java.service.cashcoupons.model.StartStockResponse;
import com.wechat.pay.java.service.cashcoupons.model.Stock;
import com.wechat.pay.java.service.cashcoupons.model.StockCollection;
import com.wechat.pay.java.service.cashcoupons.model.StopStockRequest;
import com.wechat.pay.java.service.cashcoupons.model.StopStockResponse;
import com.wechat.pay.java.service.cashcoupons.model.UseFlowRequest;
import com.wechat.pay.java.service.cashcoupons.model.UseFlowResponse;

/** CashCouponsService服务 */
public class CashCouponsService {

  private final HttpClient httpClient;
  private final HostName hostName;

  private CashCouponsService(HttpClient httpClient, HostName hostName) {
    this.httpClient = requireNonNull(httpClient);
    this.hostName = hostName;
  }

  /** CashCouponsService构造器 */
  public static class Builder {

    private HttpClient httpClient;
    private HostName hostName;

    public Builder config(Config config) {
      this.httpClient = new DefaultHttpClientBuilder().config(config).build();

      return this;
    }

    public Builder hostName(HostName hostName) {
      this.hostName = hostName;
      return this;
    }

    public Builder httpClient(HttpClient httpClient) {
      this.httpClient = httpClient;
      return this;
    }

    public CashCouponsService build() {
      return new CashCouponsService(httpClient, hostName);
    }
  }

  /**
   * 查询代金券消息通知地址
   *
   * @param request 请求参数
   * @return Callback
   * @throws HttpException 发送HTTP请求失败。例如构建请求参数失败、发送请求失败、I/O错误等。包含请求信息。
   * @throws ValidationException 发送HTTP请求成功，验证微信支付返回签名失败。
   * @throws ServiceException 发送HTTP请求成功，服务返回异常。例如返回状态码小于200或大于等于300。
   * @throws MalformedMessageException 服务返回成功，content-type不为application/json、解析返回体失败。
   */
  public Callback queryCallback(QueryCallbackRequest request) {
    String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/favor/callbacks";

    QueryCallbackRequest realRequest = request;
    // 添加 query param
    QueryParameter queryParameter = new QueryParameter();
    if (realRequest.getMchid() != null) {
      queryParameter.add("mchid", urlEncode(realRequest.getMchid()));
    }
    requestPath += queryParameter.getQueryStr();
    if (this.hostName != null) {
      requestPath = requestPath.replaceFirst(HostName.API.getValue(), hostName.getValue());
    }
    HttpHeaders headers = new HttpHeaders();
    headers.addHeader(Constant.ACCEPT, MediaType.APPLICATION_JSON.getValue());
    headers.addHeader(Constant.CONTENT_TYPE, MediaType.APPLICATION_JSON.getValue());
    HttpRequest httpRequest =
        new HttpRequest.Builder()
            .httpMethod(HttpMethod.GET)
            .url(requestPath)
            .headers(headers)
            .build();
    HttpResponse<Callback> httpResponse = httpClient.execute(httpRequest, Callback.class);
    return httpResponse.getServiceResponse();
  }

  /**
   * 设置代金券消息通知地址
   *
   * @param request 请求参数
   * @return SetCallbackResponse
   * @throws HttpException 发送HTTP请求失败。例如构建请求参数失败、发送请求失败、I/O错误等。包含请求信息。
   * @throws ValidationException 发送HTTP请求成功，验证微信支付返回签名失败。
   * @throws ServiceException 发送HTTP请求成功，服务返回异常。例如返回状态码小于200或大于等于300。
   * @throws MalformedMessageException 服务返回成功，content-type不为application/json、解析返回体失败。
   */
  public SetCallbackResponse setCallback(SetCallbackRequest request) {
    String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/favor/callbacks";
    SetCallbackRequest realRequest = request;
    if (this.hostName != null) {
      requestPath = requestPath.replaceFirst(HostName.API.getValue(), hostName.getValue());
    }
    HttpHeaders headers = new HttpHeaders();
    headers.addHeader(Constant.ACCEPT, MediaType.APPLICATION_JSON.getValue());
    headers.addHeader(Constant.CONTENT_TYPE, MediaType.APPLICATION_JSON.getValue());
    HttpRequest httpRequest =
        new HttpRequest.Builder()
            .httpMethod(HttpMethod.POST)
            .url(requestPath)
            .headers(headers)
            .body(createRequestBody(realRequest))
            .build();
    HttpResponse<SetCallbackResponse> httpResponse =
        httpClient.execute(httpRequest, SetCallbackResponse.class);
    return httpResponse.getServiceResponse();
  }

  /**
   * 根据过滤条件查询用户的券
   *
   * @param request 请求参数
   * @return CouponCollection
   * @throws HttpException 发送HTTP请求失败。例如构建请求参数失败、发送请求失败、I/O错误等。包含请求信息。
   * @throws ValidationException 发送HTTP请求成功，验证微信支付返回签名失败。
   * @throws ServiceException 发送HTTP请求成功，服务返回异常。例如返回状态码小于200或大于等于300。
   * @throws MalformedMessageException 服务返回成功，content-type不为application/json、解析返回体失败。
   */
  public CouponCollection listCouponsByFilter(ListCouponsByFilterRequest request) {
    String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/favor/users/{openid}/coupons";

    ListCouponsByFilterRequest realRequest = request;
    // 添加 path param
    requestPath = requestPath.replace("{" + "openid" + "}", urlEncode(realRequest.getOpenid()));

    // 添加 query param
    QueryParameter queryParameter = new QueryParameter();
    if (realRequest.getAppid() != null) {
      queryParameter.add("appid", urlEncode(realRequest.getAppid()));
    }
    if (realRequest.getStockId() != null) {
      queryParameter.add("stock_id", urlEncode(realRequest.getStockId()));
    }
    if (realRequest.getStatus() != null) {
      queryParameter.add("status", urlEncode(realRequest.getStatus()));
    }
    if (realRequest.getCreatorMchid() != null) {
      queryParameter.add("creator_mchid", urlEncode(realRequest.getCreatorMchid()));
    }
    if (realRequest.getSenderMchid() != null) {
      queryParameter.add("sender_mchid", urlEncode(realRequest.getSenderMchid()));
    }
    if (realRequest.getAvailableMchid() != null) {
      queryParameter.add("available_mchid", urlEncode(realRequest.getAvailableMchid()));
    }
    if (realRequest.getOffset() != null) {
      queryParameter.add("offset", urlEncode(realRequest.getOffset().toString()));
    }
    if (realRequest.getLimit() != null) {
      queryParameter.add("limit", urlEncode(realRequest.getLimit().toString()));
    }
    requestPath += queryParameter.getQueryStr();
    if (this.hostName != null) {
      requestPath = requestPath.replaceFirst(HostName.API.getValue(), hostName.getValue());
    }
    HttpHeaders headers = new HttpHeaders();
    headers.addHeader(Constant.ACCEPT, MediaType.APPLICATION_JSON.getValue());
    headers.addHeader(Constant.CONTENT_TYPE, MediaType.APPLICATION_JSON.getValue());
    HttpRequest httpRequest =
        new HttpRequest.Builder()
            .httpMethod(HttpMethod.GET)
            .url(requestPath)
            .headers(headers)
            .build();
    HttpResponse<CouponCollection> httpResponse =
        httpClient.execute(httpRequest, CouponCollection.class);
    return httpResponse.getServiceResponse();
  }

  /**
   * 查询代金券详情
   *
   * @param request 请求参数
   * @return Coupon
   * @throws HttpException 发送HTTP请求失败。例如构建请求参数失败、发送请求失败、I/O错误等。包含请求信息。
   * @throws ValidationException 发送HTTP请求成功，验证微信支付返回签名失败。
   * @throws ServiceException 发送HTTP请求成功，服务返回异常。例如返回状态码小于200或大于等于300。
   * @throws MalformedMessageException 服务返回成功，content-type不为application/json、解析返回体失败。
   */
  public Coupon queryCoupon(QueryCouponRequest request) {
    String requestPath =
        "https://api.mch.weixin.qq.com/v3/marketing/favor/users/{openid}/coupons/{coupon_id}";

    QueryCouponRequest realRequest = request;
    // 添加 path param
    requestPath =
        requestPath.replace("{" + "coupon_id" + "}", urlEncode(realRequest.getCouponId()));

    requestPath = requestPath.replace("{" + "openid" + "}", urlEncode(realRequest.getOpenid()));

    // 添加 query param
    QueryParameter queryParameter = new QueryParameter();
    if (realRequest.getAppid() != null) {
      queryParameter.add("appid", urlEncode(realRequest.getAppid()));
    }
    requestPath += queryParameter.getQueryStr();
    if (this.hostName != null) {
      requestPath = requestPath.replaceFirst(HostName.API.getValue(), hostName.getValue());
    }
    HttpHeaders headers = new HttpHeaders();
    headers.addHeader(Constant.ACCEPT, MediaType.APPLICATION_JSON.getValue());
    headers.addHeader(Constant.CONTENT_TYPE, MediaType.APPLICATION_JSON.getValue());
    HttpRequest httpRequest =
        new HttpRequest.Builder()
            .httpMethod(HttpMethod.GET)
            .url(requestPath)
            .headers(headers)
            .build();
    HttpResponse<Coupon> httpResponse = httpClient.execute(httpRequest, Coupon.class);
    return httpResponse.getServiceResponse();
  }

  /**
   * 发放指定批次的代金券
   *
   * @param request 请求参数
   * @return SendCouponResponse
   * @throws HttpException 发送HTTP请求失败。例如构建请求参数失败、发送请求失败、I/O错误等。包含请求信息。
   * @throws ValidationException 发送HTTP请求成功，验证微信支付返回签名失败。
   * @throws ServiceException 发送HTTP请求成功，服务返回异常。例如返回状态码小于200或大于等于300。
   * @throws MalformedMessageException 服务返回成功，content-type不为application/json、解析返回体失败。
   */
  public SendCouponResponse sendCoupon(SendCouponRequest request) {
    String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/favor/users/{openid}/coupons";

    SendCouponRequest realRequest = request;
    // 添加 path param
    requestPath = requestPath.replace("{" + "openid" + "}", urlEncode(realRequest.getOpenid()));

    if (this.hostName != null) {
      requestPath = requestPath.replaceFirst(HostName.API.getValue(), hostName.getValue());
    }
    HttpHeaders headers = new HttpHeaders();
    headers.addHeader(Constant.ACCEPT, MediaType.APPLICATION_JSON.getValue());
    headers.addHeader(Constant.CONTENT_TYPE, MediaType.APPLICATION_JSON.getValue());
    HttpRequest httpRequest =
        new HttpRequest.Builder()
            .httpMethod(HttpMethod.POST)
            .url(requestPath)
            .headers(headers)
            .body(createRequestBody(realRequest))
            .build();
    HttpResponse<SendCouponResponse> httpResponse =
        httpClient.execute(httpRequest, SendCouponResponse.class);
    return httpResponse.getServiceResponse();
  }

  /**
   * 创建代金券批次
   *
   * @param request 请求参数
   * @return CreateCouponStockResponse
   * @throws HttpException 发送HTTP请求失败。例如构建请求参数失败、发送请求失败、I/O错误等。包含请求信息。
   * @throws ValidationException 发送HTTP请求成功，验证微信支付返回签名失败。
   * @throws ServiceException 发送HTTP请求成功，服务返回异常。例如返回状态码小于200或大于等于300。
   * @throws MalformedMessageException 服务返回成功，content-type不为application/json、解析返回体失败。
   */
  public CreateCouponStockResponse createCouponStock(CreateCouponStockRequest request) {
    String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/favor/coupon-stocks";
    CreateCouponStockRequest realRequest = request;
    if (this.hostName != null) {
      requestPath = requestPath.replaceFirst(HostName.API.getValue(), hostName.getValue());
    }
    HttpHeaders headers = new HttpHeaders();
    headers.addHeader(Constant.ACCEPT, MediaType.APPLICATION_JSON.getValue());
    headers.addHeader(Constant.CONTENT_TYPE, MediaType.APPLICATION_JSON.getValue());
    HttpRequest httpRequest =
        new HttpRequest.Builder()
            .httpMethod(HttpMethod.POST)
            .url(requestPath)
            .headers(headers)
            .body(createRequestBody(realRequest))
            .build();
    HttpResponse<CreateCouponStockResponse> httpResponse =
        httpClient.execute(httpRequest, CreateCouponStockResponse.class);
    return httpResponse.getServiceResponse();
  }

  /**
   * 查询代金券可用商户
   *
   * @param request 请求参数
   * @return AvailableMerchantCollection
   * @throws HttpException 发送HTTP请求失败。例如构建请求参数失败、发送请求失败、I/O错误等。包含请求信息。
   * @throws ValidationException 发送HTTP请求成功，验证微信支付返回签名失败。
   * @throws ServiceException 发送HTTP请求成功，服务返回异常。例如返回状态码小于200或大于等于300。
   * @throws MalformedMessageException 服务返回成功，content-type不为application/json、解析返回体失败。
   */
  public AvailableMerchantCollection listAvailableMerchants(ListAvailableMerchantsRequest request) {
    String requestPath =
        "https://api.mch.weixin.qq.com/v3/marketing/favor/stocks/{stock_id}/merchants";

    ListAvailableMerchantsRequest realRequest = request;
    // 添加 path param
    requestPath = requestPath.replace("{" + "stock_id" + "}", urlEncode(realRequest.getStockId()));

    // 添加 query param
    QueryParameter queryParameter = new QueryParameter();
    if (realRequest.getOffset() != null) {
      queryParameter.add("offset", urlEncode(realRequest.getOffset().toString()));
    }
    if (realRequest.getLimit() != null) {
      queryParameter.add("limit", urlEncode(realRequest.getLimit().toString()));
    }
    if (realRequest.getStockCreatorMchid() != null) {
      queryParameter.add("stock_creator_mchid", urlEncode(realRequest.getStockCreatorMchid()));
    }
    requestPath += queryParameter.getQueryStr();
    if (this.hostName != null) {
      requestPath = requestPath.replaceFirst(HostName.API.getValue(), hostName.getValue());
    }
    HttpHeaders headers = new HttpHeaders();
    headers.addHeader(Constant.ACCEPT, MediaType.APPLICATION_JSON.getValue());
    headers.addHeader(Constant.CONTENT_TYPE, MediaType.APPLICATION_JSON.getValue());
    HttpRequest httpRequest =
        new HttpRequest.Builder()
            .httpMethod(HttpMethod.GET)
            .url(requestPath)
            .headers(headers)
            .build();
    HttpResponse<AvailableMerchantCollection> httpResponse =
        httpClient.execute(httpRequest, AvailableMerchantCollection.class);
    return httpResponse.getServiceResponse();
  }

  /**
   * 查询可核销商品编码
   *
   * @param request 请求参数
   * @return AvailableSingleitemCollection
   * @throws HttpException 发送HTTP请求失败。例如构建请求参数失败、发送请求失败、I/O错误等。包含请求信息。
   * @throws ValidationException 发送HTTP请求成功，验证微信支付返回签名失败。
   * @throws ServiceException 发送HTTP请求成功，服务返回异常。例如返回状态码小于200或大于等于300。
   * @throws MalformedMessageException 服务返回成功，content-type不为application/json、解析返回体失败。
   */
  public AvailableSingleitemCollection listAvailableSingleitems(
      ListAvailableSingleitemsRequest request) {
    String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/favor/stocks/{stock_id}/items";

    ListAvailableSingleitemsRequest realRequest = request;
    // 添加 path param
    requestPath = requestPath.replace("{" + "stock_id" + "}", urlEncode(realRequest.getStockId()));

    // 添加 query param
    QueryParameter queryParameter = new QueryParameter();
    if (realRequest.getOffset() != null) {
      queryParameter.add("offset", urlEncode(realRequest.getOffset().toString()));
    }
    if (realRequest.getLimit() != null) {
      queryParameter.add("limit", urlEncode(realRequest.getLimit().toString()));
    }
    if (realRequest.getStockCreatorMchid() != null) {
      queryParameter.add("stock_creator_mchid", urlEncode(realRequest.getStockCreatorMchid()));
    }
    requestPath += queryParameter.getQueryStr();
    if (this.hostName != null) {
      requestPath = requestPath.replaceFirst(HostName.API.getValue(), hostName.getValue());
    }
    HttpHeaders headers = new HttpHeaders();
    headers.addHeader(Constant.ACCEPT, MediaType.APPLICATION_JSON.getValue());
    headers.addHeader(Constant.CONTENT_TYPE, MediaType.APPLICATION_JSON.getValue());
    HttpRequest httpRequest =
        new HttpRequest.Builder()
            .httpMethod(HttpMethod.GET)
            .url(requestPath)
            .headers(headers)
            .build();
    HttpResponse<AvailableSingleitemCollection> httpResponse =
        httpClient.execute(httpRequest, AvailableSingleitemCollection.class);
    return httpResponse.getServiceResponse();
  }

  /**
   * 条件查询批次列表
   *
   * @param request 请求参数
   * @return StockCollection
   * @throws HttpException 发送HTTP请求失败。例如构建请求参数失败、发送请求失败、I/O错误等。包含请求信息。
   * @throws ValidationException 发送HTTP请求成功，验证微信支付返回签名失败。
   * @throws ServiceException 发送HTTP请求成功，服务返回异常。例如返回状态码小于200或大于等于300。
   * @throws MalformedMessageException 服务返回成功，content-type不为application/json、解析返回体失败。
   */
  public StockCollection listStocks(ListStocksRequest request) {
    String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/favor/stocks";

    ListStocksRequest realRequest = request;
    // 添加 query param
    QueryParameter queryParameter = new QueryParameter();
    if (realRequest.getOffset() != null) {
      queryParameter.add("offset", urlEncode(realRequest.getOffset().toString()));
    }
    if (realRequest.getLimit() != null) {
      queryParameter.add("limit", urlEncode(realRequest.getLimit().toString()));
    }
    if (realRequest.getStockCreatorMchid() != null) {
      queryParameter.add("stock_creator_mchid", urlEncode(realRequest.getStockCreatorMchid()));
    }
    if (realRequest.getCreateStartTime() != null) {
      queryParameter.add("create_start_time", urlEncode(realRequest.getCreateStartTime()));
    }
    if (realRequest.getCreateEndTime() != null) {
      queryParameter.add("create_end_time", urlEncode(realRequest.getCreateEndTime()));
    }
    if (realRequest.getStatus() != null) {
      queryParameter.add("status", urlEncode(realRequest.getStatus()));
    }
    requestPath += queryParameter.getQueryStr();
    if (this.hostName != null) {
      requestPath = requestPath.replaceFirst(HostName.API.getValue(), hostName.getValue());
    }
    HttpHeaders headers = new HttpHeaders();
    headers.addHeader(Constant.ACCEPT, MediaType.APPLICATION_JSON.getValue());
    headers.addHeader(Constant.CONTENT_TYPE, MediaType.APPLICATION_JSON.getValue());
    HttpRequest httpRequest =
        new HttpRequest.Builder()
            .httpMethod(HttpMethod.GET)
            .url(requestPath)
            .headers(headers)
            .build();
    HttpResponse<StockCollection> httpResponse =
        httpClient.execute(httpRequest, StockCollection.class);
    return httpResponse.getServiceResponse();
  }

  /**
   * 暂停批次
   *
   * @param request 请求参数
   * @return PauseStockResponse
   * @throws HttpException 发送HTTP请求失败。例如构建请求参数失败、发送请求失败、I/O错误等。包含请求信息。
   * @throws ValidationException 发送HTTP请求成功，验证微信支付返回签名失败。
   * @throws ServiceException 发送HTTP请求成功，服务返回异常。例如返回状态码小于200或大于等于300。
   * @throws MalformedMessageException 服务返回成功，content-type不为application/json、解析返回体失败。
   */
  public PauseStockResponse pauseStock(PauseStockRequest request) {
    String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/favor/stocks/{stock_id}/pause";

    PauseStockRequest realRequest = request;
    // 添加 path param
    requestPath = requestPath.replace("{" + "stock_id" + "}", urlEncode(realRequest.getStockId()));

    if (this.hostName != null) {
      requestPath = requestPath.replaceFirst(HostName.API.getValue(), hostName.getValue());
    }
    HttpHeaders headers = new HttpHeaders();
    headers.addHeader(Constant.ACCEPT, MediaType.APPLICATION_JSON.getValue());
    headers.addHeader(Constant.CONTENT_TYPE, MediaType.APPLICATION_JSON.getValue());
    HttpRequest httpRequest =
        new HttpRequest.Builder()
            .httpMethod(HttpMethod.POST)
            .url(requestPath)
            .headers(headers)
            .body(createRequestBody(realRequest))
            .build();
    HttpResponse<PauseStockResponse> httpResponse =
        httpClient.execute(httpRequest, PauseStockResponse.class);
    return httpResponse.getServiceResponse();
  }

  /**
   * 查询批次详情
   *
   * @param request 请求参数
   * @return Stock
   * @throws HttpException 发送HTTP请求失败。例如构建请求参数失败、发送请求失败、I/O错误等。包含请求信息。
   * @throws ValidationException 发送HTTP请求成功，验证微信支付返回签名失败。
   * @throws ServiceException 发送HTTP请求成功，服务返回异常。例如返回状态码小于200或大于等于300。
   * @throws MalformedMessageException 服务返回成功，content-type不为application/json、解析返回体失败。
   */
  public Stock queryStock(QueryStockRequest request) {
    String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/favor/stocks/{stock_id}";

    QueryStockRequest realRequest = request;
    // 添加 path param
    requestPath = requestPath.replace("{" + "stock_id" + "}", urlEncode(realRequest.getStockId()));

    // 添加 query param
    QueryParameter queryParameter = new QueryParameter();
    if (realRequest.getStockCreatorMchid() != null) {
      queryParameter.add("stock_creator_mchid", urlEncode(realRequest.getStockCreatorMchid()));
    }
    requestPath += queryParameter.getQueryStr();
    if (this.hostName != null) {
      requestPath = requestPath.replaceFirst(HostName.API.getValue(), hostName.getValue());
    }
    HttpHeaders headers = new HttpHeaders();
    headers.addHeader(Constant.ACCEPT, MediaType.APPLICATION_JSON.getValue());
    headers.addHeader(Constant.CONTENT_TYPE, MediaType.APPLICATION_JSON.getValue());
    HttpRequest httpRequest =
        new HttpRequest.Builder()
            .httpMethod(HttpMethod.GET)
            .url(requestPath)
            .headers(headers)
            .build();
    HttpResponse<Stock> httpResponse = httpClient.execute(httpRequest, Stock.class);
    return httpResponse.getServiceResponse();
  }

  /**
   * 下载批次退款明细
   *
   * @param request 请求参数
   * @return RefundFlowResponse
   * @throws HttpException 发送HTTP请求失败。例如构建请求参数失败、发送请求失败、I/O错误等。包含请求信息。
   * @throws ValidationException 发送HTTP请求成功，验证微信支付返回签名失败。
   * @throws ServiceException 发送HTTP请求成功，服务返回异常。例如返回状态码小于200或大于等于300。
   * @throws MalformedMessageException 服务返回成功，content-type不为application/json、解析返回体失败。
   */
  public RefundFlowResponse refundFlow(RefundFlowRequest request) {
    String requestPath =
        "https://api.mch.weixin.qq.com/v3/marketing/favor/stocks/{stock_id}/refund-flow";

    RefundFlowRequest realRequest = request;
    // 添加 path param
    requestPath = requestPath.replace("{" + "stock_id" + "}", urlEncode(realRequest.getStockId()));

    if (this.hostName != null) {
      requestPath = requestPath.replaceFirst(HostName.API.getValue(), hostName.getValue());
    }
    HttpHeaders headers = new HttpHeaders();
    headers.addHeader(Constant.ACCEPT, MediaType.APPLICATION_JSON.getValue());
    headers.addHeader(Constant.CONTENT_TYPE, MediaType.APPLICATION_JSON.getValue());
    HttpRequest httpRequest =
        new HttpRequest.Builder()
            .httpMethod(HttpMethod.GET)
            .url(requestPath)
            .headers(headers)
            .build();
    HttpResponse<RefundFlowResponse> httpResponse =
        httpClient.execute(httpRequest, RefundFlowResponse.class);
    return httpResponse.getServiceResponse();
  }

  /**
   * 重启批次
   *
   * @param request 请求参数
   * @return RestartStockResponse
   * @throws HttpException 发送HTTP请求失败。例如构建请求参数失败、发送请求失败、I/O错误等。包含请求信息。
   * @throws ValidationException 发送HTTP请求成功，验证微信支付返回签名失败。
   * @throws ServiceException 发送HTTP请求成功，服务返回异常。例如返回状态码小于200或大于等于300。
   * @throws MalformedMessageException 服务返回成功，content-type不为application/json、解析返回体失败。
   */
  public RestartStockResponse restartStock(RestartStockRequest request) {
    String requestPath =
        "https://api.mch.weixin.qq.com/v3/marketing/favor/stocks/{stock_id}/restart";

    RestartStockRequest realRequest = request;
    // 添加 path param
    requestPath = requestPath.replace("{" + "stock_id" + "}", urlEncode(realRequest.getStockId()));

    if (this.hostName != null) {
      requestPath = requestPath.replaceFirst(HostName.API.getValue(), hostName.getValue());
    }
    HttpHeaders headers = new HttpHeaders();
    headers.addHeader(Constant.ACCEPT, MediaType.APPLICATION_JSON.getValue());
    headers.addHeader(Constant.CONTENT_TYPE, MediaType.APPLICATION_JSON.getValue());
    HttpRequest httpRequest =
        new HttpRequest.Builder()
            .httpMethod(HttpMethod.POST)
            .url(requestPath)
            .headers(headers)
            .body(createRequestBody(realRequest))
            .build();
    HttpResponse<RestartStockResponse> httpResponse =
        httpClient.execute(httpRequest, RestartStockResponse.class);
    return httpResponse.getServiceResponse();
  }

  /**
   * 激活开启批次
   *
   * @param request 请求参数
   * @return StartStockResponse
   * @throws HttpException 发送HTTP请求失败。例如构建请求参数失败、发送请求失败、I/O错误等。包含请求信息。
   * @throws ValidationException 发送HTTP请求成功，验证微信支付返回签名失败。
   * @throws ServiceException 发送HTTP请求成功，服务返回异常。例如返回状态码小于200或大于等于300。
   * @throws MalformedMessageException 服务返回成功，content-type不为application/json、解析返回体失败。
   */
  public StartStockResponse startStock(StartStockRequest request) {
    String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/favor/stocks/{stock_id}/start";

    StartStockRequest realRequest = request;
    // 添加 path param
    requestPath = requestPath.replace("{" + "stock_id" + "}", urlEncode(realRequest.getStockId()));

    if (this.hostName != null) {
      requestPath = requestPath.replaceFirst(HostName.API.getValue(), hostName.getValue());
    }
    HttpHeaders headers = new HttpHeaders();
    headers.addHeader(Constant.ACCEPT, MediaType.APPLICATION_JSON.getValue());
    headers.addHeader(Constant.CONTENT_TYPE, MediaType.APPLICATION_JSON.getValue());
    HttpRequest httpRequest =
        new HttpRequest.Builder()
            .httpMethod(HttpMethod.POST)
            .url(requestPath)
            .headers(headers)
            .body(createRequestBody(realRequest))
            .build();
    HttpResponse<StartStockResponse> httpResponse =
        httpClient.execute(httpRequest, StartStockResponse.class);
    return httpResponse.getServiceResponse();
  }

  /**
   * 终止批次
   *
   * @param request 请求参数
   * @return StopStockResponse
   * @throws HttpException 发送HTTP请求失败。例如构建请求参数失败、发送请求失败、I/O错误等。包含请求信息。
   * @throws ValidationException 发送HTTP请求成功，验证微信支付返回签名失败。
   * @throws ServiceException 发送HTTP请求成功，服务返回异常。例如返回状态码小于200或大于等于300。
   * @throws MalformedMessageException 服务返回成功，content-type不为application/json、解析返回体失败。
   */
  public StopStockResponse stopStock(StopStockRequest request) {
    String requestPath = "https://api.mch.weixin.qq.com/v3/marketing/favor/stocks/{stock_id}/stop";

    StopStockRequest realRequest = request;
    // 添加 path param
    requestPath = requestPath.replace("{" + "stock_id" + "}", urlEncode(realRequest.getStockId()));

    if (this.hostName != null) {
      requestPath = requestPath.replaceFirst(HostName.API.getValue(), hostName.getValue());
    }
    HttpHeaders headers = new HttpHeaders();
    headers.addHeader(Constant.ACCEPT, MediaType.APPLICATION_JSON.getValue());
    headers.addHeader(Constant.CONTENT_TYPE, MediaType.APPLICATION_JSON.getValue());
    HttpRequest httpRequest =
        new HttpRequest.Builder()
            .httpMethod(HttpMethod.POST)
            .url(requestPath)
            .headers(headers)
            .body(createRequestBody(realRequest))
            .build();
    HttpResponse<StopStockResponse> httpResponse =
        httpClient.execute(httpRequest, StopStockResponse.class);
    return httpResponse.getServiceResponse();
  }

  /**
   * 下载批次核销明细
   *
   * @param request 请求参数
   * @return UseFlowResponse
   * @throws HttpException 发送HTTP请求失败。例如构建请求参数失败、发送请求失败、I/O错误等。包含请求信息。
   * @throws ValidationException 发送HTTP请求成功，验证微信支付返回签名失败。
   * @throws ServiceException 发送HTTP请求成功，服务返回异常。例如返回状态码小于200或大于等于300。
   * @throws MalformedMessageException 服务返回成功，content-type不为application/json、解析返回体失败。
   */
  public UseFlowResponse useFlow(UseFlowRequest request) {
    String requestPath =
        "https://api.mch.weixin.qq.com/v3/marketing/favor/stocks/{stock_id}/use-flow";

    UseFlowRequest realRequest = request;
    // 添加 path param
    requestPath = requestPath.replace("{" + "stock_id" + "}", urlEncode(realRequest.getStockId()));

    if (this.hostName != null) {
      requestPath = requestPath.replaceFirst(HostName.API.getValue(), hostName.getValue());
    }
    HttpHeaders headers = new HttpHeaders();
    headers.addHeader(Constant.ACCEPT, MediaType.APPLICATION_JSON.getValue());
    headers.addHeader(Constant.CONTENT_TYPE, MediaType.APPLICATION_JSON.getValue());
    HttpRequest httpRequest =
        new HttpRequest.Builder()
            .httpMethod(HttpMethod.GET)
            .url(requestPath)
            .headers(headers)
            .build();
    HttpResponse<UseFlowResponse> httpResponse =
        httpClient.execute(httpRequest, UseFlowResponse.class);
    return httpResponse.getServiceResponse();
  }

  private RequestBody createRequestBody(Object request) {
    return new JsonRequestBody.Builder().body(toJson(request)).build();
  }
}
