/*
 * Decompiled with CFR 0.152.
 */
package com.github.trang.druid.autoconfigure;

import com.alibaba.druid.filter.config.ConfigFilter;
import com.alibaba.druid.filter.logging.CommonsLogFilter;
import com.alibaba.druid.filter.logging.Log4j2Filter;
import com.alibaba.druid.filter.logging.Log4jFilter;
import com.alibaba.druid.filter.logging.Slf4jLogFilter;
import com.alibaba.druid.filter.stat.StatFilter;
import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.wall.WallConfig;
import com.alibaba.druid.wall.WallFilter;
import com.github.trang.druid.autoconfigure.DruidDataSourceConfiguration;
import com.github.trang.druid.autoconfigure.DruidServletConfiguration;
import com.github.trang.druid.autoconfigure.DruidStatConfiguration;
import com.github.trang.druid.autoconfigure.properties.DruidDataSourceProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@ConditionalOnClass(value={DruidDataSource.class})
@AutoConfigureBefore(value={DataSourceAutoConfiguration.class})
@EnableConfigurationProperties(value={DataSourceProperties.class, DruidDataSourceProperties.class})
@Import(value={DruidDataSourceConfiguration.class, DruidServletConfiguration.class, DruidStatConfiguration.class})
public class DruidAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(DruidAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.datasource.druid.stat", name={"enabled"}, havingValue="true", matchIfMissing=true)
    @ConfigurationProperties(prefix="spring.datasource.druid.stat")
    public StatFilter statFilter() {
        log.debug("druid stat-filter init...");
        return new StatFilter();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.datasource.druid.wall", name={"enabled"}, havingValue="true")
    @ConfigurationProperties(prefix="spring.datasource.druid.wall.config")
    public WallConfig wallConfig() {
        return new WallConfig();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.datasource.druid.wall", name={"enabled"}, havingValue="true")
    @ConfigurationProperties(prefix="spring.datasource.druid.wall")
    public WallFilter wallFilter(WallConfig wallConfig) {
        log.debug("druid wall-filter init...");
        WallFilter filter = new WallFilter();
        filter.setConfig(wallConfig);
        return filter;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.datasource.druid.config", name={"enabled"}, havingValue="true")
    public ConfigFilter configFilter() {
        log.debug("druid config-filter init...");
        return new ConfigFilter();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.datasource.druid.slf4j", name={"enabled"}, havingValue="true")
    @ConfigurationProperties(prefix="spring.datasource.druid.slf4j")
    public Slf4jLogFilter slf4jLogFilter() {
        log.debug("druid slf4j-filter init...");
        return new Slf4jLogFilter();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.datasource.druid.log4j", name={"enabled"}, havingValue="true")
    @ConfigurationProperties(prefix="spring.datasource.druid.log4j")
    public Log4jFilter log4jFilter() {
        log.debug("druid log4j-filter init...");
        return new Log4jFilter();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.datasource.druid.log4j2", name={"enabled"}, havingValue="true")
    @ConfigurationProperties(prefix="spring.datasource.druid.log4j2")
    public Log4j2Filter log4j2Filter() {
        log.debug("druid log4j2-filter init...");
        return new Log4j2Filter();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.datasource.druid.commons-log", name={"enabled"}, havingValue="true")
    @ConfigurationProperties(prefix="spring.datasource.druid.commons-log")
    public CommonsLogFilter commonsLogFilter() {
        log.debug("druid commons-log-filter init...");
        return new CommonsLogFilter();
    }
}

