package com.daas.nros.core.server.tools.kafka;

import com.daas.nros.core.server.tools.DateUtil;

import java.util.Date;

/**
 * @Author: Hou Hong Bin
 * @CreateTime: 2018/8/29.
 */
public class FileNameUtil {

    public static final String EXTEND_PROPERTY_PREFIX = "拓展属性导出";

    public static final String BASE_MEMBER_INFO_PREFIX = "会员基本信息导出";

    public static final String DISTRIBUTION_MEMBER_INFO_PREFIX = "分销会员信息导出";

    public static final String MEMBER_PERSONAL_INTEGRAL_PREFIX = "会员个人积分导出";

    public static final String MEMBER_GROUP_ANALYZE_PREFIX = "分组分析会员导出";

    public static final String XLS_SUFFIX = ".xls";

    public static final String XLSX_SUFFIX = ".xlsx";

    public static final String DATE_YYYYMMDD_MIDDLE = "yyyyMMdd";

    public static final String DATE_YYYYMMDDHHMMSS_MIDDLE = "yyyyMMddHHmmss";

    /**
     * 获取扩展属性文件名
     *
     * @return
     */
    public static String getExtendPropertyExcelFileName() {
        return getFileName(EXTEND_PROPERTY_PREFIX, DateUtil.format(new Date(), DATE_YYYYMMDDHHMMSS_MIDDLE),
                XLSX_SUFFIX);
    }

    /**
     * 获取基本会员信息文件名
     *
     * @return
     */
    public static String getBaseMemberInfoExcelFileName() {
        return getFileName(BASE_MEMBER_INFO_PREFIX, DateUtil.format(new Date(), DATE_YYYYMMDDHHMMSS_MIDDLE),
                XLSX_SUFFIX);
    }

    /**
     * 获取分销会员信息文件名
     *
     * @return
     */
    public static String getDistributionMemberInfoExcelFileName() {
        return getFileName(DISTRIBUTION_MEMBER_INFO_PREFIX, DateUtil.format(new Date(), DATE_YYYYMMDDHHMMSS_MIDDLE),
                XLSX_SUFFIX);
    }

    /**
     * 获取个人积分变更记录文件名
     *
     * @return
     */
    public static String getMemberPersonalIntegralFileName() {
        return getFileName(MEMBER_PERSONAL_INTEGRAL_PREFIX, DateUtil.format(new Date(), DATE_YYYYMMDDHHMMSS_MIDDLE),
                XLSX_SUFFIX);
    }


    public static String getMemberGroupAnalyzeFileName() {
        return getFileName(MEMBER_GROUP_ANALYZE_PREFIX, DateUtil.format(new Date(), DATE_YYYYMMDDHHMMSS_MIDDLE), XLSX_SUFFIX);
    }


    /**
     * 获取通用文件名
     *
     * @param prefix
     * @param middle
     * @param suffix
     * @return
     */
    public static String getFileName(String prefix, String middle, String suffix) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(prefix);
        buffer.append(middle);
        buffer.append(suffix);
        return buffer.toString();
    }
}
