package com.daas.nros.core.server.tools;

import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;

/**
 * @Author: Hou Hong Bin
 * @CreateTime: 2018/7/11.
 */
public class ResponseUtil {

    private static final ThreadLocal<ResponseData> threadLocal = new ThreadLocal<ResponseData>();

    /**
     * 获取相应数据对象
     *
     * @return
     */
    public static ResponseData getResponseData() {
        ResponseData responseData = threadLocal.get();
        if (responseData == null) {
            responseData = new ResponseData();
            threadLocal.set(responseData);
        }
        return responseData;
    }

    /**
     * 获取成功响应
     *
     * @param data
     * @return
     */
    public static ResponseData getSuccessData(Object data) {
        ResponseData responseData = getResponseData();
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(SysResponseEnum.SUCCESS.getMessage());
        responseData.setData(data);
        return responseData;
    }

    public static ResponseData getSuccessData(Object data, String msg) {
        ResponseData responseData = getResponseData();
        responseData.setCode(SysResponseEnum.SUCCESS.getCode());
        responseData.setMessage(msg);
        responseData.setData(data);
        return responseData;
    }

    /**
     * 获取失败响应信息
     *
     * @param data
     * @return
     */
    public static ResponseData getFailedData(Object data) {
        ResponseData responseData = getResponseData();
        responseData.setCode(SysResponseEnum.FAILED.getCode());
        responseData.setMessage(SysResponseEnum.FAILED.getMessage());
        responseData.setData(data);
        return responseData;
    }

    public static ResponseData getFailedData(Object data, String msg) {
        ResponseData responseData = getResponseData();
        responseData.setCode(SysResponseEnum.FAILED.getCode());
        responseData.setMessage(msg);
        responseData.setData(data);
        return responseData;
    }
}
