package com.daas.nros.core.server.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizvane.centerstageservice.rpc.StoreServiceRpc;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import com.daas.nros.core.api.CoreTraceService;
import com.daas.nros.core.model.po.TracePO;
import com.daas.nros.core.model.po.TraceRecordPO;
import com.daas.nros.core.model.po.TraceRecordPOExample;
import com.daas.nros.core.model.vo.TraceRecordPageVo;
import com.daas.nros.core.model.vo.TraceRecordVo;
import com.daas.nros.core.server.dao.TracePOMapper;
import com.daas.nros.core.server.dao.TraceRecordPOMapper;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.Date;
import java.util.List;

@Service
@Slf4j
public class CoreTraceServiceImpl implements CoreTraceService {

    @Autowired
    private TracePOMapper tracePOMapper;

    @Autowired
    private TraceRecordPOMapper traceRecordPOMapper;

    @Autowired
    private StoreServiceRpc storeServiceRpc;

    @Override
    public ResponseData insertTrace(TracePO po) {
        log.info("enter CoreTraceServiceImpl insertTrace method !");
        ResponseData<Long> responseData = new ResponseData<>();

        int result = tracePOMapper.insert(po);
        if (result == 0) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("新增失败");
            return responseData;
        }
        responseData.setData(po.getTraceId());
        return responseData;
    }

    @Override
    public ResponseData<TracePO> selectByTraceId(Long traceId) {
        log.info("enter CoreTraceServiceImpl selectByTraceId method !");
        ResponseData<TracePO> responseData = new ResponseData<>();
        TracePO tracePO = tracePOMapper.selectByPrimaryKey(traceId);
        responseData.setData(tracePO);
        return responseData;
    }

    @Transactional
    @Override
    public ResponseData saveTraceRecord(TraceRecordVo vo) {
        log.info("enter CoreTraceServiceImpl saveTraceRecord method !");
        ResponseData responseData = new ResponseData();
        if (vo == null || vo.getTraceId() == null) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("traceId为空");
        }
        TracePO tracePo = tracePOMapper.selectByPrimaryKey(vo.getTraceId());
        if (tracePo == null) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("traceId无效");
            return responseData;
        }
        log.info("coreTraceServiceImpl saveTraceRecord selectByPrimaryKey result:{}", JSON.toJSONString(tracePo));
        TraceRecordPO po = new TraceRecordPO();
        po.setTraceId(vo.getTraceId());
        po.setTraceValue(tracePo.getTraceValue());
        po.setCreateTime(new Date());
        po.setOpenid(vo.getOpenId());
        po.setUnionid(vo.getUnionId());
        po.setMemberCode(vo.getMemberCode());
        po.setSysCompanyId(vo.getSysCompanyId() == null ? tracePo.getSysCompanyId() : vo.getSysCompanyId());
        po.setBrandId(vo.getBrandId() == null ? tracePo.getBrandId() : vo.getBrandId());
        if (po.getBrandId() == null) {
            try {
                JSONObject obj = JSON.parseObject(tracePo.getTraceValue());
                Object storeIdObj = obj.get("storeId");
                if (storeIdObj != null) {
                    Long storeId = ((Integer) storeIdObj).longValue();

                }
            } catch (Exception e) {
                log.info("获取traceValue的storeId失败。traceId:{}", vo.getTraceId());
            }
        }
        int result = traceRecordPOMapper.insertSelective(po);
        if (result == 0) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("新增失败");
            return responseData;
        }
        return responseData;
    }

    @Override
    public ResponseData<TraceRecordPO> selectTraceRecord(TraceRecordVo vo) {
        log.info("enter CoreTraceServiceImpl selectTraceRecord method !");
        ResponseData responseData = new ResponseData();
        if (vo.getUnionId() == null) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("unionid为空");
        }
        TraceRecordPO po = new TraceRecordPO();
        po.setUnionid(vo.getUnionId());
        po.setSysCompanyId(vo.getSysCompanyId());
        po.setBrandId(vo.getBrandId());
        List<TraceRecordPO> traceRecordPoList = traceRecordPOMapper.selectByUnionId(po);
        //需求变更加上brand_id 因需要兼容老版本故多查一次
        if (CollectionUtils.isEmpty(traceRecordPoList) && po.getBrandId() != null) {
            po.setBrandId(null);
            traceRecordPoList = traceRecordPOMapper.selectByUnionIdAndBrandId(po);
        }
        if (traceRecordPoList != null && traceRecordPoList.size() > 0) {
            responseData.setData(traceRecordPoList.get(0));
        }
        return responseData;
    }

    @Override
    public ResponseData<PageInfo<TraceRecordPO>> selectTraceRecordList(TraceRecordPageVo vo) {
        log.info("enter CoreTraceServiceImpl selectTraceRecordList method !");
        ResponseData<PageInfo<TraceRecordPO>> responseData = new ResponseData();
        if (vo.getUnionId() == null) {
            responseData.setCode(SysResponseEnum.FAILED.getCode());
            responseData.setMessage("unionid为空");
            return responseData;
        }
        TraceRecordPO po = new TraceRecordPO();
        po.setUnionid(vo.getUnionId());
        po.setSysCompanyId(vo.getSysCompanyId());
        po.setBrandId(vo.getBrandId());
        Page<TraceRecordPO> page = PageHelper.startPage(vo.getPageNo(), vo.getPageSize())
                .doSelectPage(() -> traceRecordPOMapper.selectByUnionId(po));

        PageInfo<TraceRecordPO> pageInfo = new PageInfo(page);
        responseData.setData(pageInfo);
        return responseData;

    }

    @Override
    public boolean deleteTraceRecordByUnionId(String unionId) {
        if (StringUtils.isEmpty(unionId)) {
            return false;
        }
        TraceRecordPOExample example = new TraceRecordPOExample();
        example.createCriteria().andUnionidEqualTo(unionId);
        traceRecordPOMapper.deleteByExample(example);
        return true;
    }
}
