package com.daas.nros.core.server.flummi;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import de.otto.flummi.query.QueryBuilder;

import static de.otto.flummi.request.GsonHelper.object;

public class MatchQueryBuilder implements QueryBuilder {

    private final String name;
    private final JsonElement value;
    private int boost = 1;

    public MatchQueryBuilder(String name, JsonElement value) {
        this.name = name;
        this.value = value;
    }

    public MatchQueryBuilder boost(int boost) {
        this.boost = boost;
        return this;
    }

    @Override
    public JsonObject build() {
        if (name == null || name.isEmpty()) {
            throw new RuntimeException("missing property 'name'");
        }
        if (value == null) {
            throw new RuntimeException("missing property 'value'");
        }
        JsonObject term = object(name, value);
        if (boost != 1) {
            term.add("boost", new JsonPrimitive(boost));
        }
        return object("match", term);
    }

}
