package com.bizvane.wechat.feign.feign;

import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.wechat.feign.model.req.WxSendSubscribeMsgReq;
import com.bizvane.wechat.feign.model.req.base.WxBaseAppIdReq;
import com.bizvane.wechat.feign.model.rsp.WxTemplateInfoRsp;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;


@FeignClient(value = "${feign.client.wechat.name}", path = "${feign.client.wechat.path}/wxSendMsg")
public interface WechatSendMsgRpcFeign {

    @PostMapping("/sendSubscribeMsg")
    @ResponseBody
    @ApiOperation(value = "发送订阅消息")
    ResponseData<Boolean> sendSubscribeMsg(@RequestBody @Validated WxSendSubscribeMsgReq req);


    @PostMapping("/getTemplateList")
    @ResponseBody
    @ApiOperation(value = "获取个人模板列表")
    ResponseData<List<WxTemplateInfoRsp>> getTemplateList(@RequestBody @Validated WxBaseAppIdReq req);
}
