package com.bizvane.wechatfacade.interfaces;


import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * @ClassName WxParseUrlFeign
 * @DescriptTion :
 * @Auther: wd
 * @Date :2019/1/16 14:05
 */
@FeignClient(value="${feign.client.wechat.name}", path="${feign.client.wechat.path}/wxParseUrl")
public interface WxParseUrlFeign {
    @ApiOperation(value = "将七牛地址转化为微信认可的地址")
    @RequestMapping(value = "/qiNiuUrlToWxUrl", method = RequestMethod.POST)
    ResponseData<String> qiNiuUrlToWxUrl(String fromUrl,String qiNiuUrl);
}
