package com.bizvane.wechatfacade.interfaces;

import java.util.List;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.alibaba.fastjson.JSONObject;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.wechatfacade.models.po.WxMiniprgmTemplate;
import com.bizvane.wechatfacade.models.po.WxPublicPO;
import com.bizvane.wechatfacade.models.vo.WxMiniprgmReleaseLogVO;
import com.bizvane.wechatfacade.models.vo.WxMiniprgmReleaseVO;
import com.bizvane.wechatfacade.models.vo.WxMiniprgmTemplateVO;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * Created by yunjie.tian on 2018/9/17.
 */
@FeignClient(value="${feign.client.wechat.name}", path="${feign.client.wechat.path}/wxMiniprgm")
@Api(value = "小程序相关接口",tags = {"小程序相关接口"})
public interface WxMiniprgmServiceFeign {

    @ApiOperation(value = "根据appid查询要跳转的小程序")
    @RequestMapping(value = "/getJumpMiniprgm", method = RequestMethod.POST)
    @ResponseBody
    ResponseData<WxPublicPO> getJumpMiniprgm(@RequestParam(value = "appid",required = false)String appid);



    /**
     * 更新小程序发布状态
     * @return
     */
    @ApiOperation(value = "更新小程序发布状态")
    @RequestMapping(value = "/uploadCode",method = RequestMethod.POST)
    public ResponseData<Integer> uploadCode(@RequestParam("wxPublicId")Long wxPublicId,@RequestParam("templateId")Integer templateId,
                                            @RequestParam("releaseState")String releaseState);



    /**
     * 添加小程序模板
     * @return
     */
    @ApiOperation(value = "添加小程序模板")
    @RequestMapping(value = "/addMiniTemplate",method = RequestMethod.POST)
    public ResponseData<String> addMiniTemplate(@RequestBody WxMiniprgmTemplate template);


    /**
     * 更新小程序模板
     * @return
     */
    @ApiOperation(value = "更新小程序模板")
    @RequestMapping(value = "/updateMiniTemplate",method = RequestMethod.POST)
    public ResponseData<String> updateMiniTemplate(@RequestBody WxMiniprgmTemplate template);

    /**
     * 删除小程序模板
     * @return
     */
    @ApiOperation(value = "删除小程序模板")
    @RequestMapping(value = "/deleteMiniTemplate",method = RequestMethod.POST)
    public ResponseData<String> deleteMiniTemplate(@RequestParam(value = "wxMiniprgmTemplateId",required = false)Long wxMiniprgmTemplateId);

    /**
     * 查询小程序模板详情
     * @return
     */
    @ApiOperation(value = "查询小程序模板详情")
    @RequestMapping(value = "/findMiniTemplate",method = RequestMethod.POST)
    public ResponseData<WxMiniprgmTemplateVO> findMiniTemplate(@RequestParam(value = "wxMiniprgmTemplateId",required = false)Long wxMiniprgmTemplateId);


    /**
     * 获取小程序模板列表
     * @return
     */
    @ApiOperation(value = "获取小程序模板列表")
    @RequestMapping(value = "/getMiniTemplateList",method = RequestMethod.POST)
    public ResponseData<List<WxMiniprgmTemplate>> getMiniTemplateList(@RequestParam(value = "conditions",required = false)String conditions,
                                                                      @RequestParam(value = "miniProgramType",required = false)String miniProgramType);
    /**
     * 查询小程序发布列表
     * @return
     */
    @ApiOperation(value = "查询小程序发布列表")
    @RequestMapping(value = "/getReleaseList",method = RequestMethod.POST)
    public ResponseData<PageInfo<WxMiniprgmReleaseVO>> getReleaseList(@RequestParam(value = "miniProgramType",required = false)String miniProgramType,
                                                                      @RequestParam(value = "conditions",required = false)String conditions,
                                                                      @RequestParam(value = "pageNumber",required = false)int pageNumber,
                                                                      @RequestParam(value = "pageSize",required = false)int pageSize);


    /**
     * 批量提交代码
     * @return
     */
    @ApiOperation(value = "批量提交代码")
    @RequestMapping(value = "/submitCode",method = RequestMethod.POST)
    public ResponseData<String> submitCode(@RequestParam(value = "publicIdBatch",required = false)String publicIdBatch,
                                           @RequestParam(value = "releaseState",required = false)String releaseState,
                                           @RequestParam(value = "templateId",required = false)Integer templateId);


    /**
     * 批量提交审核
     * @return
     */
    @ApiOperation(value = "批量提交审核")
    @RequestMapping(value = "/submitAudit",method = RequestMethod.POST)
    public ResponseData<String> submitAudit(@RequestParam(value = "publicIdBatch",required = false)String publicIdBatch,
                                            @RequestParam(value = "releaseState",required = false)String releaseState);

    /**
     * 获取提交类目
     * @return
     */
    @ApiOperation(value = "获取提交类目")
    @RequestMapping(value = "/getCategory",method = RequestMethod.POST)
    public ResponseData<JSONObject> getCategory(String token);


    /**
     *  发布小程序
     * @return
     */
    @ApiOperation(value = "发布小程序")
    @RequestMapping(value = "/release",method = RequestMethod.POST)
    public ResponseData<String> release(@RequestParam(value = "publicIdBatch",required = false)String publicIdBatch,
                                        @RequestParam(value = "releaseState",required = false)String releaseState);


    /**
     *  小程序版本回退
     * @return
     */
    @ApiOperation(value = "小程序版本回退")
    @RequestMapping(value = "/revertVersionRelease",method = RequestMethod.POST)
    public ResponseData<String> revertVersionRelease(@RequestParam(value = "publicIdBatch",required = false)String publicIdBatch,
                                                     @RequestParam(value = "releaseState",required = false)String releaseState);


    /**
     * 查询小程序历史发布列表
     * @return
     */
    @ApiOperation(value = "查询小程序历史发布列表")
    @RequestMapping(value = "/getReleaseLogList",method = RequestMethod.POST)
    public ResponseData<PageInfo<WxMiniprgmReleaseLogVO>> getReleaseLogList(@RequestParam(value = "miniProgramType",required = false)String miniProgramType,
                                                                            @RequestParam(value = "conditions",required = false)String conditions,
                                                                            @RequestParam(value = "pageNumber",required = false)int pageNumber,
                                                                            @RequestParam(value = "pageSize",required = false)int pageSize);
}
