package com.bizvane.wechatfacade.interfaces;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.wechatfacade.models.vo.CreateMiniprgmQRCodeRequestVO;
import com.bizvane.wechatfacade.models.vo.QRCodeCreateContainImgRequestVO;
import com.bizvane.wechatfacade.models.vo.QRCodeCreateRequestVO;
import com.bizvane.wechatfacade.models.vo.UrlQRCodeCreateContainImgRequestVO;
import com.bizvane.wechatfacade.models.vo.UrlQRCodeCreateRequestVO;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

@FeignClient(value="${feign.client.wechat.name}", path="${feign.client.wechat.path}/QRCode")
@Api(value = "二维码相关接口",tags = {"二维码相关接口"})
public interface QRCodeServiceFeign {
  
  @ApiOperation(value = "创建带参数二维码")
  @RequestMapping(value = "/createQRCode", method = RequestMethod.POST)
  @ResponseBody
  ResponseData<String> createQRCode(@RequestBody QRCodeCreateRequestVO vo);
  
  @ApiOperation(value = "创建带参数包含自定义图片二维码")
  @RequestMapping(value = "/createQRCodeContainImg", method = RequestMethod.POST)
  @ResponseBody
  ResponseData<String> createQRCodeContainImg(@RequestBody QRCodeCreateContainImgRequestVO vo);
  
  @ApiOperation(value = "创建自定义url二维码")
  @RequestMapping(value = "/createUrlQRCode", method = RequestMethod.POST)
  @ResponseBody
  ResponseData<String> createUrlQRCode(@RequestBody UrlQRCodeCreateRequestVO vo);
  
  @ApiOperation(value = "创建自定义url包含自定义图片二维码")
  @RequestMapping(value = "/createUrlQRCodeContainImg", method = RequestMethod.POST)
  @ResponseBody
  ResponseData<String> createUrlQRCodeContainImg(@RequestBody UrlQRCodeCreateContainImgRequestVO vo);
  
  @ApiOperation(value = "创建小程序自定义页面二维码")
  @RequestMapping(value = "/createMiniprgmQRCode", method = RequestMethod.POST)
  @ResponseBody
  ResponseData<String> createMiniprgmQRCode(@RequestBody CreateMiniprgmQRCodeRequestVO vo);
  
}
