package com.bizvane.tiktokmembers.facade.vo.rsp;

import lombok.Data;

@Data
public class Certificate {
    private String certificate_id;
    private String combination_id;
    /**
     * item单（券维度的）状态
     *
     * ( OrderItemStatus_Init 初始化 OrderItemStatus = 0
     *
     * OrderItemStatus_Finish 交易成功 OrderItemStatus = 1
     *
     * OrderItemStatus_WaitPay 待支付 OrderItemStatus = 10
     *
     * OrderItemStatus_PartPay  部分支付  OrderItemStatus = 15
     *
     * OrderItemStatus_PaySuccess 支付成功 OrderItemStatus = 20
     *
     * OrderItemStatus_Availabe 待使用 OrderItemStatus = 100
     *
     * OrderItemStatus_Close 交易关闭 OrderItemStatus = 101
     *
     * OrderItemStatus_Booking 预约中 OrderItemStatus = 200
     *
     * OrderItemStatus_BookSuccess 已预约 OrderItemStatus = 201
     *
     * OrderItemStatus_Refunding 退款中 OrderItemStatus = 300
     *
     * OrderItemStatus_RefundSuccess 已退款 OrderItemStatus = 301
     *
     * OrderItemStatus_Fulfilling 履约中 OrderItemStatus = 400
     *
     * OrderItemStatus_FulfilSuccess 已履约 OrderItemStatus = 401）
     */
    private Long item_status;
    private Long item_update_time;
    private String order_item_id;
    private Long refund_amount;
    private Long refund_time;
}