/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.task.center.feign;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

public class SQLWhereClauseBuilder {
    public static void main(String[] args) {
        String jsonTemplate = "{\n    \"key1\": {\n        \"column\": \"column1\",\n        \"table\": \"table2\",\n        \"operator\": \"=\",\n        \"type\": \"string\"\n    },\n    \"key2\": {\n        \"column\": \"column2\",\n        \"table\": \"table2\",\n        \"operator\": \"in\",\n        \"type\": \"int\"\n    },\n    \"key3\": {\n        \"column\": \"column3\",\n        \"table\": \"table1\",\n        \"operator\": \"between\",\n        \"type\": \"string\"\n    },\n    \"key4\": {\n        \"column\": \"column4\",\n        \"table\": \"table1\",\n        \"operator\": \"=\",\n        \"type\": \"subquery\",\n        \"subquery\": {\n            \"column\": \"subqueryColumn\",\n            \"table\": \"subqueryTable1\",\n            \"aggregateType\": \"sum\",\n            \"type\": \"string\",\n            \"joins\": [\n                {\n                    \"type\": \"INNER JOIN\",\n                    \"table\": \"subqueryTable2\",\n                    \"on\": \"subqueryTable1.customer_id = subqueryTable2.id\"\n                },\n                {\n                    \"type\": \"INNER JOIN\",\n                    \"table\": \"subqueryTable3\",\n                    \"on\": \"subqueryTable1.customer_id = subqueryTable3.id\"\n                }\n            ],\n            \"subqueryCondition1\": {\n                \"column\": \"column2\",\n                \"table\": \"subqueryTable1\",\n                \"operator\": \"in\",\n                \"type\": \"int\"\n            },\n            \"subqueryCondition2\": {\n                \"column\": \"column3\",\n                \"table\": \"subqueryTable2\",\n                \"operator\": \"=\",\n                \"type\": \"int\"\n            },\n            \"groupBy\": \"groupByColumn\",\n            \"having\": {\n                \"column\": \"havingColumn\",\n                \"table\": \"subqueryTable1\",\n                \"aggregateType\": \"sum\",\n                \"operator\": \"=\",\n                \"type\": \"int\"\n            }\n        }\n    }\n}";
        String jsonValues = "{\n    \"\u5bfc\u51fa\u7684\u4e1a\u52a1\u903b\u8f91\": \"\u4e1a\u52a1\u903b\u8f91code\u6216ID\",\n     \"key1\":111,\n     \"key2\":[1,2,3,4,5,6],\n     \"key3\":{\n         \"min\":1,\n         \"max\":5\n     },\n     \"key4\":{\n         \"subqueryCondition1\":[2,3,4,5,6],\n         \"subqueryCondition2\":333,\n         \"having\":1\n     }\n}";
        JSONObject template = JSONObject.parseObject((String)jsonTemplate);
        JSONObject values = JSONObject.parseObject((String)jsonValues);
        StringBuilder whereClause = new StringBuilder();
        SQLWhereClauseBuilder.buildWhereClause(template, values, whereClause);
        whereClause.insert(0, "  WHERE  ");
        System.out.println(" " + whereClause);
    }

    private static void buildWhereClause(JSONObject template, JSONObject values, StringBuilder whereClause) {
        for (String key : values.keySet()) {
            String condition = "";
            if (!template.containsKey((Object)key)) continue;
            JSONObject column = template.getJSONObject(key);
            String table = column.getString("table");
            String columnName = column.getString("column");
            String operator = column.getString("operator");
            String type = column.getString("type");
            Object value = values.get((Object)key);
            if (column.containsKey((Object)"subquery") && "subquery".equals(type)) {
                System.out.println("\u5b58\u5728\u5b50\u67e5\u8be2: " + key);
                JSONObject subquery = column.getJSONObject("subquery");
                JSONObject subqueryValues = values.getJSONObject(key);
                String subquerySQL = SQLWhereClauseBuilder.buildSubquerySQL(subquery, subqueryValues, column);
                condition = SQLWhereClauseBuilder.buildCondition(columnName, operator, subquerySQL, type, table);
                System.out.println("condition: " + condition);
            } else {
                condition = SQLWhereClauseBuilder.buildCondition(columnName, operator, value, type, table);
            }
            if (condition.isEmpty()) continue;
            if (whereClause.length() > 0) {
                whereClause.append(" AND ");
            }
            whereClause.append(condition);
        }
    }

    private static String buildCondition(String columnName, String operator, Object value, String type, String table) {
        switch (operator.toLowerCase()) {
            case "=": {
                return table + "." + columnName + " = " + SQLWhereClauseBuilder.quoteValue(value, type);
            }
            case "in": {
                if (value instanceof JSONArray) {
                    JSONArray array = (JSONArray)value;
                    StringBuilder inValues = new StringBuilder("(");
                    for (int i = 0; i < array.size(); ++i) {
                        if (i > 0) {
                            inValues.append(", ");
                        }
                        inValues.append(SQLWhereClauseBuilder.quoteValue(array.get(i), type));
                    }
                    inValues.append(")");
                    return table + "." + columnName + " IN " + inValues.toString();
                }
                if (!(value instanceof String)) break;
                return table + "." + columnName + " IN (" + value.toString() + ")";
            }
            case "between": {
                if (!(value instanceof JSONObject)) break;
                JSONObject range = (JSONObject)value;
                String min = SQLWhereClauseBuilder.quoteValue(range.get((Object)"min"), type);
                String max = SQLWhereClauseBuilder.quoteValue(range.get((Object)"max"), type);
                return table + "." + columnName + " BETWEEN " + min + " AND " + max;
            }
            default: {
                return "";
            }
        }
        return "";
    }

    private static String buildSubquerySQL(JSONObject subquery, JSONObject subqueryValues, JSONObject column) {
        StringBuilder subquerySQL = new StringBuilder("SELECT ");
        SQLWhereClauseBuilder.appendAggregateTypeIfPresent(subquery, subquerySQL);
        subquerySQL.append("  FROM  ").append(subquery.getString("table"));
        SQLWhereClauseBuilder.handleJoins(subquery, subquerySQL);
        SQLWhereClauseBuilder.handleSubqueryConditions(subquery, subqueryValues, subquerySQL);
        SQLWhereClauseBuilder.appendGroupByIfPresent(subquery, subquerySQL);
        SQLWhereClauseBuilder.appendHavingIfPresent(subquery, subqueryValues, subquerySQL);
        System.out.println("subquerySQL: " + subquerySQL);
        return subquerySQL.toString();
    }

    private static void appendAggregateTypeIfPresent(JSONObject subquery, StringBuilder subquerySQL) {
        if (subquery.containsKey((Object)"aggregateType")) {
            subquerySQL.append(subquery.getString("aggregateType")).append(" ( ").append(subquery.getString("table")).append(".").append(subquery.getString("column")).append(" ) ");
        } else {
            subquerySQL.append(subquery.getString("column"));
        }
    }

    private static void handleJoins(JSONObject subquery, StringBuilder subquerySQL) {
        if (subquery.containsKey((Object)"joins")) {
            JSONArray joins = subquery.getJSONArray("joins");
            for (int i = 0; i < joins.size(); ++i) {
                JSONObject join = joins.getJSONObject(i);
                subquerySQL.append(" ").append(join.getString("type")).append(" ").append(join.getString("table")).append(" ON ").append(join.getString("on"));
            }
        }
    }

    private static void appendGroupByIfPresent(JSONObject subquery, StringBuilder subquerySQL) {
        if (subquery.containsKey((Object)"groupBy")) {
            subquerySQL.append(" GROUP BY ").append(subquery.getString("groupBy"));
        }
    }

    private static void appendHavingIfPresent(JSONObject subquery, JSONObject subqueryValues, StringBuilder subquerySQL) {
        if (subquery.containsKey((Object)"having")) {
            JSONObject having = subquery.getJSONObject("having");
            System.out.println("having: " + having);
            subquerySQL.append(" HAVING ").append(having.getString("aggregateType")).append("(").append(SQLWhereClauseBuilder.buildCondition(having.getString("column") + " ) ", having.getString("operator"), subqueryValues.get((Object)"having"), having.getString("type"), having.getString("table")));
        }
    }

    private static void handleSubqueryConditions(JSONObject subquery, JSONObject subqueryValues, StringBuilder subquerySQL) {
        subquerySQL.append(" WHERE ");
        StringBuilder whereClause = new StringBuilder();
        for (String key : subqueryValues.keySet()) {
            if (!subquery.containsKey((Object)key)) continue;
            JSONObject column = subquery.getJSONObject(key);
            String table = column.getString("table");
            String columnName = column.getString("column");
            String operator = column.getString("operator");
            String type = column.getString("type");
            Object value = subqueryValues.get((Object)key);
            String condition = SQLWhereClauseBuilder.buildCondition(columnName, operator, value, type, table);
            if (condition.isEmpty()) continue;
            if (whereClause.length() > 0) {
                whereClause.append(" AND ");
            }
            whereClause.append(condition);
        }
        subquerySQL.append((CharSequence)whereClause);
    }

    private static String generateCondition(String columnName, String operator, Object value, String type, String table) {
        switch (operator.toLowerCase()) {
            case "=": {
                return table + "." + columnName + " = " + SQLWhereClauseBuilder.quoteValue(value, type);
            }
            case "in": {
                if (!(value instanceof JSONArray)) break;
                JSONArray array = (JSONArray)value;
                StringBuilder inValues = new StringBuilder();
                for (int i = 0; i < array.size(); ++i) {
                    if (i > 0) {
                        inValues.append(", ");
                    }
                    inValues.append(SQLWhereClauseBuilder.quoteValue(array.get(i), type));
                }
                return table + "." + columnName + " IN (" + inValues.toString() + ")";
            }
            case "between": {
                if (!(value instanceof JSONObject)) break;
                JSONObject range = (JSONObject)value;
                String min = SQLWhereClauseBuilder.quoteValue(range.get((Object)"min"), type);
                String max = SQLWhereClauseBuilder.quoteValue(range.get((Object)"max"), type);
                return table + "." + columnName + " BETWEEN " + min + " AND " + max;
            }
            default: {
                return "";
            }
        }
        return "";
    }

    private static String quoteValue(Object value, String type) {
        if ("string".equals(type) || "date".equals(type)) {
            return "'" + value.toString().replace("'", "''") + "'";
        }
        if ("subquery".equals(type)) {
            return "(" + value.toString() + ")";
        }
        return value.toString();
    }
}

