/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.task.center.api.service.service;

import com.bizvane.members.feign.model.bo.MbrLevelUpdateRequestBO;
import com.bizvane.members.feign.model.vo.MbrLevelDefVO;
import com.bizvane.members.feign.model.vo.MbrMembersDetailVO;
import com.bizvane.members.feign.service.MbrLevelFeign;
import com.bizvane.members.feign.service.MbrMemberFeign;
import com.bizvane.task.center.domain.model.entity.WrbkMembersDowngradeResultsPO;
import com.bizvane.task.center.domain.service.IWrbkMembersDowngradeResultsService;
import com.bizvane.utils.enumutils.SysOperatorEnum;
import com.bizvane.utils.responseinfo.ResponseData;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MbrMemberService {
    private static final Logger log = LoggerFactory.getLogger(MbrMemberService.class);
    @Autowired
    private IWrbkMembersDowngradeResultsService iWrbkMembersDowngradeResultsService;
    @Autowired
    private MbrLevelFeign mbrLevelFeign;
    @Autowired
    private MbrMemberFeign mbrMemberFeign;

    public void mbrDownLevel() {
        List levelDefList = (List)this.mbrLevelFeign.defListAll().getData();
        long minId = 0L;
        block2: while (true) {
            List recordPOList;
            if (CollectionUtils.isEmpty((Collection)(recordPOList = this.iWrbkMembersDowngradeResultsService.list(minId, 1, 1000).getRecords()))) {
                log.info("\u4efb\u52a1\u660e\u7ec6\u5df2\u6267\u884c\u5b8c\u6210:{}", (Object)minId);
                break;
            }
            minId = ((WrbkMembersDowngradeResultsPO)recordPOList.get(recordPOList.size() - 1)).getId();
            Iterator iterator = recordPOList.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block2;
                WrbkMembersDowngradeResultsPO recordPO = (WrbkMembersDowngradeResultsPO)iterator.next();
                try {
                    this.extracted(recordPO, levelDefList);
                }
                catch (Exception e) {
                    log.error("\u4f1a\u5458\u964d\u7ea7\u5f02\u5e38:{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
                }
            }
            break;
        }
    }

    private void extracted(WrbkMembersDowngradeResultsPO recordPO, List<MbrLevelDefVO> levelDefList) {
        String mbrMembersCode = recordPO.getMbrMembersCode();
        if (StringUtils.isBlank((CharSequence)mbrMembersCode)) {
            log.info("\u4f1a\u5458mbrMembersCode\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u964d\u7ea7");
            recordPO.setDowngradeStatus(Integer.valueOf(2));
            recordPO.setResult("\u4f1a\u5458mbrMembersCode\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u964d\u7ea7");
            this.iWrbkMembersDowngradeResultsService.updateById((Object)recordPO);
            return;
        }
        MbrMembersDetailVO mbrMembersDetailVO = (MbrMembersDetailVO)this.mbrMemberFeign.detail(mbrMembersCode).getData();
        if (mbrMembersDetailVO == null) {
            log.info("\u4f1a\u5458\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u964d\u7ea7:{}", (Object)mbrMembersCode);
            recordPO.setDowngradeStatus(Integer.valueOf(2));
            recordPO.setResult("\u4f1a\u5458\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u964d\u7ea7");
            this.iWrbkMembersDowngradeResultsService.updateById((Object)recordPO);
            return;
        }
        MbrLevelDefVO mbrLevelDefVO = this.getDownTargetLevel(levelDefList, recordPO.getMbrLevelDefCode(), mbrMembersDetailVO.getMbrLevelDefCode());
        if (mbrLevelDefVO == null) {
            log.info("\u65e0\u9700\u964d\u7ea7:{}", (Object)mbrMembersCode);
            recordPO.setDowngradeStatus(Integer.valueOf(2));
            recordPO.setResult("\u65e0\u9700\u964d\u7ea7");
            this.iWrbkMembersDowngradeResultsService.updateById((Object)recordPO);
            return;
        }
        MbrLevelUpdateRequestBO levelUpdateRequestBO = MbrLevelUpdateRequestBO.builder().mbrMembersCode(mbrMembersDetailVO.getMbrMembersCode()).mbrLevelDefCode(mbrLevelDefVO.getMbrLevelDefCode()).originMbrLevelDefCode(mbrMembersDetailVO.getMbrLevelDefCode()).opsType(Integer.valueOf(1)).changeDate(LocalDateTime.now()).userCode(SysOperatorEnum.SYS_BATCH_TASK.getType()).userName(SysOperatorEnum.SYS_BATCH_TASK.getTypeDes()).build();
        ResponseData updateMbrLevelResult = this.mbrLevelFeign.updateMbrLevel(levelUpdateRequestBO);
        recordPO.setDowngradeStatus(Integer.valueOf(2));
        recordPO.setResult(updateMbrLevelResult.getMessage());
        this.iWrbkMembersDowngradeResultsService.updateById((Object)recordPO);
    }

    private MbrLevelDefVO getDownTargetLevel(List<MbrLevelDefVO> levelDefList, String mbrLevelDefCode, String currentMbrLevelDefCode) {
        MbrLevelDefVO mbrLevelDefVO;
        if (CollectionUtils.isEmpty(levelDefList) || levelDefList.size() == 1) {
            return null;
        }
        int j = levelDefList.size() - 1;
        for (int i = 0; i < levelDefList.size() - 1; ++i) {
            MbrLevelDefVO mbrLevelDefVO2 = levelDefList.get(i);
            if (!mbrLevelDefVO2.getMbrLevelDefCode().equals(mbrLevelDefCode)) continue;
            j = i + 1;
            break;
        }
        if ((mbrLevelDefVO = levelDefList.get(j)).getMbrLevelDefCode().equals(currentMbrLevelDefCode)) {
            return null;
        }
        return mbrLevelDefVO;
    }
}

