/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.task.center.api.service.service;

import com.bizvane.basic.feign.enums.TSysCryptoDataBizTypeEnums;
import com.bizvane.basic.feign.feign.SysCryptoRpcFeign;
import com.bizvane.basic.feign.model.vo.TSysCryptoDataVo;
import com.bizvane.members.feign.model.bo.MbrMemberLabelChangeRequestParam;
import com.bizvane.members.feign.model.vo.MbrMembersVO;
import com.bizvane.members.feign.service.MbrLabelFeign;
import com.bizvane.members.feign.service.MbrMemberFeign;
import com.bizvane.task.center.api.service.common.enums.BatchExecuteStatusEnum;
import com.bizvane.task.center.api.service.common.enums.BatchTaskRecordStatusEnum;
import com.bizvane.task.center.domain.config.BusinessNoUtils;
import com.bizvane.task.center.domain.model.entity.BatchTaskPO;
import com.bizvane.task.center.domain.model.entity.BatchTaskRecordPO;
import com.bizvane.task.center.domain.service.IBatchTaskRecordService;
import com.bizvane.task.center.domain.service.IBatchTaskService;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.excel.ExcelImportUtil;
import com.bizvane.utils.responseinfo.ResponseData;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MbrLabelService {
    private static final Logger log = LoggerFactory.getLogger(MbrLabelService.class);
    @Autowired
    private IBatchTaskService iBatchTaskService;
    @Autowired
    private MbrMemberFeign mbrMemberFeign;
    @Autowired
    private MbrLabelFeign mbrLabelFeign;
    @Autowired
    private IBatchTaskRecordService iBatchTaskRecordService;
    @Autowired
    private SysCryptoRpcFeign sysCryptoRpcFeign;

    public void detailExecuting(BatchTaskPO batchTaskPO) {
        String batchTaskCode = batchTaskPO.getBatchTaskCode();
        String businessCode = batchTaskPO.getBusinessCode();
        long minId = 0L;
        block0: while (true) {
            List recordPOList;
            if (CollectionUtils.isEmpty((Collection)(recordPOList = this.iBatchTaskRecordService.page(batchTaskCode, Integer.valueOf(0), Long.valueOf(minId), 1, 100).getRecords()))) {
                log.info("\u4efb\u52a1\u660e\u7ec6\u5df2\u6267\u884c\u5b8c\u6210:{}", (Object)minId);
                break;
            }
            minId = ((BatchTaskRecordPO)recordPOList.get(recordPOList.size() - 1)).getId();
            Iterator iterator = recordPOList.iterator();
            while (true) {
                int status;
                if (!iterator.hasNext()) continue block0;
                BatchTaskRecordPO recordPO = (BatchTaskRecordPO)iterator.next();
                TSysCryptoDataVo cryptoDataVo = new TSysCryptoDataVo();
                cryptoDataVo.setBizType(TSysCryptoDataBizTypeEnums.MEMBERS.getType());
                cryptoDataVo.setData(recordPO.getBusinessCode());
                String phoneEncrypt = (String)this.sysCryptoRpcFeign.encryptData(cryptoDataVo).getData();
                MbrMembersVO mbrMembersVO = (MbrMembersVO)this.mbrMemberFeign.getMemberByPhone(phoneEncrypt).getData();
                String failDetail = null;
                if (mbrMembersVO != null) {
                    ResponseData dealResult = this.mbrLabelFeign.addMbrLabel(MbrMemberLabelChangeRequestParam.builder().mbrMembersCode(mbrMembersVO.getMbrMembersCode()).mbrLabelDefCodeList(Collections.singletonList(businessCode)).userCode(batchTaskPO.getCreateUserCode()).userName(batchTaskPO.getCreateUserName()).build());
                    if (SysResponseEnum.SUCCESS.getCode() == dealResult.getCode()) {
                        status = BatchTaskRecordStatusEnum.SUCCESS.getType();
                    } else {
                        status = BatchTaskRecordStatusEnum.FAIL.getType();
                        failDetail = dealResult.getMessage();
                    }
                } else {
                    log.info("\u4f1a\u5458\u4e0d\u5b58\u5728\uff0c\u624b\u673a\u53f71\uff1a{}", (Object)recordPO.getBusinessCode());
                    status = BatchTaskRecordStatusEnum.FAIL.getType();
                    failDetail = "\u4f1a\u5458\u4e0d\u5b58\u5728";
                }
                this.iBatchTaskRecordService.updateStatus(batchTaskCode, recordPO.getBusinessCode(), Integer.valueOf(status), failDetail);
            }
            break;
        }
        this.iBatchTaskService.updateStatus(batchTaskPO.getBatchTaskCode(), BatchExecuteStatusEnum.COMPLETE.getType());
    }

    public void detailGenerating(BatchTaskPO batchTaskPO) {
        String businessBatchCode = batchTaskPO.getBusinessBatchCode();
        String batchTaskCode = batchTaskPO.getBatchTaskCode();
        List list = (List)this.getImportData(batchTaskPO.getParam()).getData();
        if (CollectionUtils.isEmpty((Collection)list)) {
            log.error("\u83b7\u53d6\u751f\u6210\u660e\u7ec6\u7684\u4efb\u52a1\u4e3a\u7a7a");
            return;
        }
        for (String cardNo : list) {
            if (null != this.iBatchTaskRecordService.detail(batchTaskCode, cardNo)) {
                log.info("\u91cd\u590d\u5206\u7ec4\u660e\u7ec6\u76f4\u63a5\u8df3\u8fc7");
                continue;
            }
            BatchTaskRecordPO recordPO = new BatchTaskRecordPO();
            recordPO.setBatchTaskRecordCode(BusinessNoUtils.getSystemNo());
            recordPO.setBatchTaskCode(batchTaskCode);
            recordPO.setBusinessCode(cardNo);
            recordPO.setStatus(BatchTaskRecordStatusEnum.NEW.getType());
            recordPO.setCreateUserCode(batchTaskPO.getCreateUserCode());
            recordPO.setCreateUserName(batchTaskPO.getCreateUserName());
            recordPO.setCreateDate(LocalDateTime.now());
            if (this.iBatchTaskRecordService.save((Object)recordPO)) continue;
            log.info("\u5206\u7ec4\u660e\u7ec6\u5199\u5165\u5931\u8d25\uff1a");
            return;
        }
        log.info("\u66f4\u65b0\u6279\u91cf\u8c03\u6574\u4efb\u52a1\u8fdb\u5ea6:{}", (Object)businessBatchCode);
        this.iBatchTaskService.updateStatus(batchTaskPO.getBatchTaskCode(), BatchExecuteStatusEnum.WAIT_EXECUTE_DETAIL.getType());
    }

    public ResponseData<List<String>> getImportData(String excelUrl) {
        ExcelImportUtil excelImportUtil = new ExcelImportUtil();
        ArrayList importList = new ArrayList();
        List excelData = excelImportUtil.parseExcel(excelUrl);
        for (List row : excelData) {
            importList.add(row.get(0));
        }
        return new ResponseData(importList);
    }
}

