/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.task.center.api.service.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.bizvane.basic.feign.feign.BasicMerchantRpcFeign;
import com.bizvane.basic.feign.model.vo.TBasicMerchantVo;
import com.bizvane.members.feign.model.bo.MbrIntegralAddRequestParam;
import com.bizvane.members.feign.model.bo.MbrIntegralSubRequestParam;
import com.bizvane.members.feign.model.vo.MbrMembersVO;
import com.bizvane.members.feign.service.IntegralFeign;
import com.bizvane.members.feign.service.MbrMemberFeign;
import com.bizvane.task.center.api.service.common.enums.BatchExecuteStatusEnum;
import com.bizvane.task.center.api.service.common.enums.BatchTaskTypeEnum;
import com.bizvane.task.center.api.service.model.vo.MbrIntegralBatchTaskExcelVO;
import com.bizvane.task.center.domain.model.dto.MbrIntegralBatchTaskDetailListRequestDTO;
import com.bizvane.task.center.domain.model.entity.BatchTaskPO;
import com.bizvane.task.center.domain.model.entity.MbrIntegralBatchDetailPO;
import com.bizvane.task.center.domain.model.entity.MbrIntegralBatchPO;
import com.bizvane.task.center.domain.service.IBatchTaskService;
import com.bizvane.task.center.domain.service.IMbrIntegralBatchDetailService;
import com.bizvane.task.center.domain.service.IMbrIntegralBatchService;
import com.bizvane.task.center.feign.model.bo.BatchTaskAddRequestDTO;
import com.bizvane.task.center.feign.model.bo.MbrIntegralAddBatchTaskDetailRequestParam;
import com.bizvane.task.center.feign.model.bo.MbrIntegralAddBatchTaskRequestParam;
import com.bizvane.task.center.feign.model.bo.MbrIntegralBatchTaskDetailListRequestParam;
import com.bizvane.task.center.feign.model.bo.MbrIntegralBatchTaskListRequestParam;
import com.bizvane.task.center.feign.model.vo.MbrIntegralBatchDetailVO;
import com.bizvane.task.center.feign.model.vo.MbrIntegralBatchVO;
import com.bizvane.utils.enumutils.IntegralBusinessWayEnum;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.excel.ExcelImportUtil;
import com.bizvane.utils.exception.BizException;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class MbrIntegralBatchService {
    private static final Logger log = LoggerFactory.getLogger(MbrIntegralBatchService.class);
    @Autowired
    private IMbrIntegralBatchService iMbrIntegralBatchService;
    @Autowired
    private IMbrIntegralBatchDetailService iMbrIntegralBatchDetailService;
    @Autowired
    private IBatchTaskService iBatchTaskService;
    @Autowired
    private MbrMemberFeign mbrMemberFeign;
    @Autowired
    private IntegralFeign integralFeign;
    @Lazy
    @Autowired
    private MbrIntegralBatchService mbrIntegralBatchService;
    @Autowired
    private BasicMerchantRpcFeign basicMerchantRpcFeign;

    @Transactional
    public ResponseData<String> addBatchTask(MbrIntegralAddBatchTaskRequestParam param) {
        String mbrIntegralBatchCode = this.iMbrIntegralBatchService.add(param);
        if (StringUtils.isEmpty((CharSequence)mbrIntegralBatchCode)) {
            log.error("\u65b0\u589e\u4efb\u52a1\u8bb0\u5f55\u5931\u8d251");
            throw new BizException(-1, "\u521b\u5efa\u4e1a\u52a1\u4efb\u52a1\u5931\u8d25");
        }
        BatchTaskAddRequestDTO taskParam = BatchTaskAddRequestDTO.builder().businessBatchCode(mbrIntegralBatchCode).taskName(param.getTaskName()).taskType(BatchTaskTypeEnum.CHANGE_INTEGRAL.getType()).param(param.getUrl()).userCode(param.getUserCode()).userName(param.getUserName()).build();
        String batchTaskCode = this.iBatchTaskService.add(taskParam);
        if (StringUtils.isEmpty((CharSequence)batchTaskCode)) {
            log.error("\u65b0\u589e\u4efb\u52a1\u8bb0\u5f55\u5931\u8d252");
            throw new BizException(-1, "\u521b\u5efa\u901a\u7528\u4efb\u52a1\u5931\u8d25");
        }
        return new ResponseData();
    }

    public PageInfo<MbrIntegralBatchVO> list(MbrIntegralBatchTaskListRequestParam param) {
        IPage page = this.iMbrIntegralBatchService.list(param);
        ArrayList<MbrIntegralBatchVO> list = new ArrayList<MbrIntegralBatchVO>();
        for (MbrIntegralBatchPO po : page.getRecords()) {
            MbrIntegralBatchVO vo = new MbrIntegralBatchVO();
            BeanUtils.copyProperties((Object)po, (Object)vo);
            list.add(vo);
        }
        return new PageInfo((int)page.getCurrent(), (int)page.getSize(), page.getTotal(), list);
    }

    public PageInfo<MbrIntegralBatchDetailVO> listDetail(MbrIntegralBatchTaskDetailListRequestParam param) {
        MbrIntegralBatchTaskDetailListRequestDTO dto = MbrIntegralBatchTaskDetailListRequestDTO.builder().mbrIntegralBatchCode(param.getMbrIntegralBatchCode()).cardNo(param.getCardNo()).status(param.getStatus()).pageNum(param.getPageNum()).pageSize(param.getPageSize()).build();
        IPage page = this.iMbrIntegralBatchDetailService.list(dto);
        ArrayList<MbrIntegralBatchDetailVO> list = new ArrayList<MbrIntegralBatchDetailVO>();
        for (MbrIntegralBatchDetailPO po : page.getRecords()) {
            MbrIntegralBatchDetailVO vo = new MbrIntegralBatchDetailVO();
            BeanUtils.copyProperties((Object)po, (Object)vo);
            list.add(vo);
        }
        return new PageInfo((int)page.getCurrent(), (int)page.getSize(), page.getTotal(), list);
    }

    @Transactional
    public ResponseData<String> addBatchTaskDetail(MbrIntegralAddBatchTaskDetailRequestParam param) {
        log.info("MbrIntegralService.addBatchTaskDetail:{}", (Object)JacksonUtil.bean2Json((Object)param));
        String mbrIntegralBatchCodeDetail = this.iMbrIntegralBatchDetailService.add(param);
        if (StringUtils.isNotEmpty((CharSequence)mbrIntegralBatchCodeDetail)) {
            log.error("\u65b0\u589e\u8bb0\u5f55\u5931\u8d25");
            return new ResponseData(-1, "\u65b0\u589e\u8bb0\u5f55\u5931\u8d25");
        }
        return new ResponseData((Object)mbrIntegralBatchCodeDetail);
    }

    public void detailExecuting(BatchTaskPO batchTaskPO) {
        String businessBatchCode = batchTaskPO.getBusinessBatchCode();
        long minId = 0L;
        while (true) {
            MbrIntegralBatchTaskDetailListRequestDTO dto;
            List list;
            if ((list = this.iMbrIntegralBatchDetailService.list(dto = MbrIntegralBatchTaskDetailListRequestDTO.builder().mbrIntegralBatchCode(businessBatchCode).status(Integer.valueOf(0)).minId(Long.valueOf(minId)).pageNum(1).pageSize(1000).build()).getRecords()).isEmpty()) break;
            for (MbrIntegralBatchDetailPO detailPO : list) {
                this.mbrIntegralBatchService.extracted(batchTaskPO, detailPO);
            }
            minId = ((MbrIntegralBatchDetailPO)list.get(list.size() - 1)).getId();
        }
        log.info("\u672c\u6b21\u6267\u884c\u5b8c\u6210");
        this.iMbrIntegralBatchService.updateStatus(businessBatchCode, Integer.valueOf(1), null, null);
        this.iBatchTaskService.updateStatus(batchTaskPO.getBatchTaskCode(), BatchExecuteStatusEnum.COMPLETE.getType());
    }

    @Transactional
    public void extracted(BatchTaskPO batchTaskPO, MbrIntegralBatchDetailPO detailPO) {
        MbrIntegralSubRequestParam integralAddRequestParam;
        MbrMembersVO mbrMembersVO = (MbrMembersVO)this.mbrMemberFeign.getMemberByCardNo(detailPO.getCardNo()).getData();
        if (mbrMembersVO == null) {
            log.error("\u4f1a\u5458\u4e0d\u5b58\u5728\uff0c\u8df3\u8fc7:{}", (Object)detailPO.getCardNo());
            detailPO.setStatus(Integer.valueOf(2));
            detailPO.setFailDetail("\u4f1a\u5458\u4e0d\u5b58\u5728\uff0c\u8df3\u8fc7");
            this.iMbrIntegralBatchDetailService.updateById((Object)detailPO);
            return;
        }
        Integer changeIntegral = detailPO.getChangeIntegral();
        ResponseData changeResponse = null;
        if (changeIntegral > 0) {
            integralAddRequestParam = MbrIntegralAddRequestParam.builder().mbrMembersCode(mbrMembersVO.getMbrMembersCode()).changeBills(detailPO.getMbrIntegralBatchCodeDetail()).changeSource(batchTaskPO.getBatchTaskCode()).changeDetails(batchTaskPO.getTaskName()).changeIntegral(detailPO.getChangeIntegral()).changeDate(LocalDateTime.now()).businessWay(IntegralBusinessWayEnum.BATCH_UPDATE_SUB.getType()).airportNo(detailPO.getAirportNo()).industryNo(detailPO.getIndustryNo()).merchantNo(detailPO.getMerchantNo()).expiredTime(LocalDateTime.now().plusDays(detailPO.getIntegralValidDay().intValue()).toLocalDate().atTime(LocalTime.MAX)).userCode(batchTaskPO.getCreateUserCode()).userName(batchTaskPO.getCreateUserName()).build();
            changeResponse = this.integralFeign.add((MbrIntegralAddRequestParam)integralAddRequestParam);
        } else {
            integralAddRequestParam = MbrIntegralSubRequestParam.builder().mbrMembersCode(mbrMembersVO.getMbrMembersCode()).changeBills(detailPO.getMbrIntegralBatchCodeDetail()).changeSource(batchTaskPO.getBatchTaskCode()).changeDetails(batchTaskPO.getTaskName()).changeIntegral(detailPO.getChangeIntegral()).changeDate(LocalDateTime.now()).businessWay(IntegralBusinessWayEnum.BATCH_UPDATE_ADD.getType()).airportNo(detailPO.getAirportNo()).industryNo(detailPO.getIndustryNo()).merchantNo(detailPO.getMerchantNo()).userCode(batchTaskPO.getCreateUserCode()).userName(batchTaskPO.getCreateUserName()).build();
            changeResponse = this.integralFeign.sub(integralAddRequestParam);
        }
        boolean changeResult = SysResponseEnum.SUCCESS.getCode() == changeResponse.getCode();
        detailPO.setPhone(mbrMembersVO.getPhone());
        detailPO.setMbrMembersCode(mbrMembersVO.getMbrMembersCode());
        this.iMbrIntegralBatchDetailService.updateById((Object)detailPO);
        boolean updateStatus = this.iMbrIntegralBatchDetailService.updateStatus(detailPO.getMbrIntegralBatchCodeDetail(), Integer.valueOf(changeResult ? 1 : 2), changeResult ? null : changeResponse.getMessage());
        if (!updateStatus) {
            log.error("\u66f4\u65b0\u4efb\u52a1\u660e\u7ec6\u72b6\u6001\u5931\u8d25:{}", (Object)detailPO.getMbrIntegralBatchCodeDetail());
            throw new BizException(-1, "\u66f4\u65b0\u4efb\u52a1\u660e\u7ec6\u72b6\u6001\u5931\u8d25");
        }
        this.iMbrIntegralBatchService.updateStatus(batchTaskPO.getBusinessBatchCode(), Integer.valueOf(1), changeResult ? Integer.valueOf(1) : null, changeResult ? null : Integer.valueOf(1));
    }

    public void detailGenerating(BatchTaskPO batchTaskPO) {
        log.info("MbrIntegralService.detailGenerating\u5f00\u59cb\u6267\u884c");
        String businessBatchCode = batchTaskPO.getBusinessBatchCode();
        TBasicMerchantVo mbrMerchantParam = new TBasicMerchantVo();
        mbrMerchantParam.setStatus(Boolean.valueOf(true));
        Map merchantMap = ((List)this.basicMerchantRpcFeign.list(mbrMerchantParam).getData()).stream().collect(Collectors.toMap(TBasicMerchantVo::getMerchantCode, Function.identity()));
        List list = (List)this.getImportData(batchTaskPO.getParam()).getData();
        if (CollectionUtils.isEmpty((Collection)list)) {
            log.error("\u83b7\u53d6\u751f\u6210\u660e\u7ec6\u7684\u4efb\u52a1\u4e3a\u7a7a");
            return;
        }
        for (MbrIntegralBatchTaskExcelVO excelVO : list) {
            String cardNo = excelVO.getCardNo();
            MbrIntegralBatchDetailPO detailPO = this.iMbrIntegralBatchDetailService.detail(businessBatchCode, cardNo);
            if (detailPO != null) {
                log.info("\u4efb\u52a1\u660e\u7ec6\u5df2\u751f\u6210\uff0c\u8df3\u8fc7:{}", (Object)cardNo);
                continue;
            }
            TBasicMerchantVo baseMerchantVo = (TBasicMerchantVo)merchantMap.get(excelVO.getMerchantNo());
            if (baseMerchantVo == null) {
                log.error("\u5546\u6237\u4e0d\u5b58\u5728\uff0c\u8df3\u8fc7:{}", (Object)excelVO.getMerchantNo());
                continue;
            }
            MbrIntegralAddBatchTaskDetailRequestParam param = MbrIntegralAddBatchTaskDetailRequestParam.builder().mbrIntegralBatchCode(businessBatchCode).cardNo(cardNo).changeIntegral(excelVO.getChangeIntegral()).integralValidDay(excelVO.getIntegralValidDay()).airportNo(baseMerchantVo.getAirportCode()).industryNo(baseMerchantVo.getBusinessCode()).merchantNo(excelVO.getMerchantNo()).userCode(batchTaskPO.getCreateUserCode()).userName(batchTaskPO.getCreateUserName()).build();
            ResponseData addDetailResult = this.addBatchTaskDetail(param);
            if (SysResponseEnum.SUCCESS.getCode() == addDetailResult.getCode()) continue;
            log.error("\u6dfb\u52a0\u660e\u7ec6\u5931\u8d25:{}", (Object)addDetailResult.getMessage());
            return;
        }
        log.info("\u66f4\u65b0\u6279\u91cf\u8c03\u6574\u4efb\u52a1\u8fdb\u5ea6:{}", (Object)businessBatchCode);
        this.iBatchTaskService.updateStatus(batchTaskPO.getBatchTaskCode(), BatchExecuteStatusEnum.WAIT_EXECUTE_DETAIL.getType());
    }

    public ResponseData<List<MbrIntegralBatchTaskExcelVO>> getImportData(String excelUrl) {
        log.info("MbrIntegralBatchService.getImportData.url:{}", (Object)excelUrl);
        ExcelImportUtil excelImportUtil = new ExcelImportUtil();
        ArrayList<MbrIntegralBatchTaskExcelVO> importList = new ArrayList<MbrIntegralBatchTaskExcelVO>();
        List excelData = excelImportUtil.parseExcel(excelUrl);
        for (List row : excelData) {
            MbrIntegralBatchTaskExcelVO vo = new MbrIntegralBatchTaskExcelVO();
            vo.setCardNo((String)row.get(0));
            vo.setChangeIntegral(Integer.valueOf(Double.valueOf((String)row.get(1)).intValue()));
            vo.setIntegralValidDay(Integer.valueOf(Double.valueOf((String)row.get(2)).intValue()));
            vo.setMerchantNo(MbrIntegralBatchService.convertToDouble((String)((String)row.get(3))));
            importList.add(vo);
        }
        return new ResponseData(importList);
    }

    public static String convertToDouble(String str) {
        if (str == null || str.isEmpty()) {
            return null;
        }
        try {
            return String.valueOf((int)Double.parseDouble(str));
        }
        catch (NumberFormatException e) {
            return str;
        }
    }
}

