/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.task.center.api.service.service;

import com.bizvane.airport.mall.feign.model.req.IntegralMallOrderCancelReq;
import com.bizvane.airport.mall.feign.model.req.IntegralMallOrderConfirmReceiptReq;
import com.bizvane.airport.mall.feign.model.req.IntegralMallOrderPageReq;
import com.bizvane.airport.mall.feign.model.res.IntegralConfigRes;
import com.bizvane.airport.mall.feign.model.res.IntegralMallOrderPageRes;
import com.bizvane.airport.mall.feign.service.IntegralMallConfigFeign;
import com.bizvane.airport.mall.feign.service.IntegralMallOrderFeign;
import com.bizvane.task.center.domain.service.IXxlJobRecordDetailService;
import com.bizvane.task.center.domain.service.IXxlJobRecordService;
import com.bizvane.utils.enumutils.IntegralMallOrderStatusEnum;
import com.bizvane.utils.enumutils.IntegralMallOrderStatusOperationTypeEnum;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IntegralMallOrderService {
    private static final Logger log = LoggerFactory.getLogger(IntegralMallOrderService.class);
    @Autowired
    private IntegralMallConfigFeign integralMallConfigFeign;
    @Autowired
    private IntegralMallOrderFeign integralMallOrderFeign;
    @Autowired
    private IXxlJobRecordService xxlJobRecordService;
    @Autowired
    private IXxlJobRecordDetailService xxlJobRecordDetailService;
    public static final String INTEGRAL_MALL_ORDER_CONFIRM_HANDLER = "integralMallOrderConfirmHandler";
    public static final String INTEGRAL_MALL_ORDER_CANCEL_HANDLER = "integralMallOrderCancelHandler";
    public static final Integer PAGE_SIZE = 100;

    public void integralMallOrderConfirm(String xxlJobRecordCode) {
        ResponseData integralConfigResData = this.integralMallConfigFeign.get();
        log.info("\u79ef\u5206\u5546\u57ce\u914d\u7f6e\u4fe1\u606f\uff1a{}", (Object)JacksonUtil.bean2Json((Object)integralConfigResData));
        if (integralConfigResData == null || integralConfigResData.getData() == null) {
            log.error("\u79ef\u5206\u5546\u57ce\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a, \u4e0d\u6267\u884c, xxlJobRecordCode:{}", (Object)xxlJobRecordCode);
            this.xxlJobRecordService.saveXxlJobRecord(xxlJobRecordCode, INTEGRAL_MALL_ORDER_CONFIRM_HANDLER, 0L, 0L);
            return;
        }
        IntegralConfigRes configRes = (IntegralConfigRes)integralConfigResData.getData();
        Integer awaitOrderDeliveryDays = configRes.getAwaitOrderDelivery();
        if (awaitOrderDeliveryDays == null || awaitOrderDeliveryDays <= 0) {
            log.error("\u79ef\u5206\u5546\u57ce\u914d\u7f6e\u4fe1\u606f, \u4e0d\u6267\u884c, \u81ea\u52a8\u786e\u8ba4\u6536\u8d27\u65f6\u95f4\u4e3a\u7a7a\u6216\u5c0f\u4e8e\u7b49\u4e8e0, xxlJobRecordCode:{}", (Object)xxlJobRecordCode);
            this.xxlJobRecordService.saveXxlJobRecord(xxlJobRecordCode, INTEGRAL_MALL_ORDER_CONFIRM_HANDLER, 0L, 0L);
            return;
        }
        IntegralMallOrderPageReq pageReq = new IntegralMallOrderPageReq();
        pageReq.setPageNum(Integer.valueOf(1));
        pageReq.setPageSize(Integer.valueOf(1));
        pageReq.setState(IntegralMallOrderStatusEnum.DELIVERY.getType());
        ResponseData pageInfoRes = this.integralMallOrderFeign.page(pageReq);
        if (pageInfoRes == null || pageInfoRes.getData() == null || ((PageInfo)pageInfoRes.getData()).getList() == null || ((PageInfo)pageInfoRes.getData()).getList().isEmpty()) {
            log.info("\u79ef\u5206\u5546\u57ce\u5df2\u53d1\u8d27\u8ba2\u5355\u4e3a\u7a7a, \u4e0d\u6267\u884c, xxlJobRecordCode:{}", (Object)xxlJobRecordCode);
            this.xxlJobRecordService.saveXxlJobRecord(xxlJobRecordCode, INTEGRAL_MALL_ORDER_CONFIRM_HANDLER, 0L, 0L);
            return;
        }
        this.xxlJobRecordService.saveXxlJobRecord(xxlJobRecordCode, INTEGRAL_MALL_ORDER_CONFIRM_HANDLER, ((PageInfo)pageInfoRes.getData()).getTotal(), ((PageInfo)pageInfoRes.getData()).getTotal());
        int i = 1;
        while ((long)i < ((PageInfo)pageInfoRes.getData()).getTotal() / (long)PAGE_SIZE.intValue()) {
            pageReq.setPageNum(Integer.valueOf(i));
            pageReq.setPageSize(PAGE_SIZE);
            pageInfoRes = this.integralMallOrderFeign.page(pageReq);
            if (pageInfoRes == null || pageInfoRes.getData() == null || ((PageInfo)pageInfoRes.getData()).getList() == null || ((PageInfo)pageInfoRes.getData()).getList().isEmpty()) {
                log.info("\u79ef\u5206\u5546\u57ce\u5df2\u53d1\u8d27\u8ba2\u5355\u4e3a\u7a7a, \u4e0d\u6267\u884c, xxlJobRecordCode:{}", (Object)xxlJobRecordCode);
                return;
            }
            for (IntegralMallOrderPageRes pageRes : ((PageInfo)pageInfoRes.getData()).getList()) {
                try {
                    this.confirmReceipt(xxlJobRecordCode, pageRes.getIntegralMallOrderCode(), pageRes.getMbrMemberCode());
                }
                catch (Exception e) {
                    log.error("\u79ef\u5206\u5546\u57ce\u786e\u8ba4\u6536\u8d27\u5f02\u5e38, xxlJobRecordCode:{}, integralMallOrderCode:{}, mbrMemberCode:{}", new Object[]{xxlJobRecordCode, pageRes.getIntegralMallOrderCode(), pageRes.getMbrMemberCode(), e});
                }
            }
            ++i;
        }
    }

    public void integralMallOrderCancel(String xxlJobRecordCode) {
        ResponseData integralConfigResData = this.integralMallConfigFeign.get();
        log.info("\u79ef\u5206\u5546\u57ce\u914d\u7f6e\u4fe1\u606f\uff1a{}", (Object)JacksonUtil.bean2Json((Object)integralConfigResData));
        if (integralConfigResData == null || integralConfigResData.getData() == null) {
            log.error("\u79ef\u5206\u5546\u57ce\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a, \u4e0d\u6267\u884c, xxlJobRecordCode:{}", (Object)xxlJobRecordCode);
            return;
        }
        IntegralConfigRes configRes = (IntegralConfigRes)integralConfigResData.getData();
        Integer awaitOrderCancelDays = configRes.getAwaitOrderCancel();
        if (awaitOrderCancelDays == null || awaitOrderCancelDays <= 0) {
            log.error("\u79ef\u5206\u5546\u57ce\u914d\u7f6e\u4fe1\u606f, \u4e0d\u6267\u884c, \u81ea\u52a8\u53d6\u6d88\u65f6\u95f4\u4e3a\u7a7a\u6216\u5c0f\u4e8e\u7b49\u4e8e0, xxlJobRecordCode:{}", (Object)xxlJobRecordCode);
            return;
        }
        IntegralMallOrderPageReq pageReq = new IntegralMallOrderPageReq();
        pageReq.setPageNum(Integer.valueOf(1));
        pageReq.setPageSize(Integer.valueOf(1));
        pageReq.setState(IntegralMallOrderStatusEnum.WAIT_PAY.getType());
        ResponseData pageInfoRes = this.integralMallOrderFeign.page(pageReq);
        if (pageInfoRes == null || pageInfoRes.getData() == null || ((PageInfo)pageInfoRes.getData()).getList() == null || ((PageInfo)pageInfoRes.getData()).getList().isEmpty()) {
            log.info("\u79ef\u5206\u5546\u57ce\u5f85\u652f\u4ed8\u8ba2\u5355\u4e3a\u7a7a, \u4e0d\u6267\u884c, xxlJobRecordCode:{}", (Object)xxlJobRecordCode);
            return;
        }
        this.xxlJobRecordService.saveXxlJobRecord(xxlJobRecordCode, INTEGRAL_MALL_ORDER_CANCEL_HANDLER, ((PageInfo)pageInfoRes.getData()).getTotal(), ((PageInfo)pageInfoRes.getData()).getTotal());
        int i = 1;
        while ((long)i < ((PageInfo)pageInfoRes.getData()).getTotal() / (long)PAGE_SIZE.intValue()) {
            pageReq.setPageNum(Integer.valueOf(i));
            pageReq.setPageSize(PAGE_SIZE);
            pageInfoRes = this.integralMallOrderFeign.page(pageReq);
            if (pageInfoRes == null || pageInfoRes.getData() == null || ((PageInfo)pageInfoRes.getData()).getList() == null || ((PageInfo)pageInfoRes.getData()).getList().isEmpty()) {
                log.info("\u79ef\u5206\u5546\u57ce\u5df2\u53d1\u8d27\u8ba2\u5355\u4e3a\u7a7a, \u4e0d\u6267\u884c, xxlJobRecordCode:{}", (Object)xxlJobRecordCode);
                break;
            }
            for (IntegralMallOrderPageRes pageRes : ((PageInfo)pageInfoRes.getData()).getList()) {
                try {
                    this.cancel(xxlJobRecordCode, pageRes.getIntegralMallOrderCode(), pageRes.getMbrMemberCode());
                }
                catch (Exception e) {
                    log.error("\u79ef\u5206\u5546\u57ce\u53d6\u6d88\u8ba2\u5355\u5f02\u5e38, xxlJobRecordCode:{}, integralMallOrderCode:{}, mbrMemberCode:{}", new Object[]{xxlJobRecordCode, pageRes.getIntegralMallOrderCode(), pageRes.getMbrMemberCode(), e});
                }
            }
            ++i;
        }
    }

    private ResponseData<Boolean> confirmReceipt(String xxlJobRecordCode, String integralMallOrderCode, String mbrMemberCode) {
        IntegralMallOrderConfirmReceiptReq receiptReq = new IntegralMallOrderConfirmReceiptReq();
        receiptReq.setIntegralMallOrderCode(integralMallOrderCode);
        receiptReq.setMbrMemberCode(mbrMemberCode);
        receiptReq.setConfirmReceiptType(IntegralMallOrderStatusOperationTypeEnum.SYSTEM_OPERATION.getType());
        ResponseData confirmReceiptRes = new ResponseData(SysResponseEnum.FAILED.getCode(), "\u79ef\u5206\u5546\u57ce\u786e\u8ba4\u6536\u8d27\u5931\u8d25");
        try {
            confirmReceiptRes = this.integralMallOrderFeign.confirmReceipt(receiptReq);
            log.info("\u79ef\u5206\u5546\u57ce\u786e\u8ba4\u6536\u8d27, xxlJobRecordCode:{}, integralMallOrderCode:{}, mbrMemberCode:{}, confirmReceiptRes:{}", new Object[]{xxlJobRecordCode, integralMallOrderCode, mbrMemberCode, JacksonUtil.bean2Json((Object)confirmReceiptRes)});
        }
        catch (Exception e) {
            log.error("\u79ef\u5206\u5546\u57ce\u786e\u8ba4\u6536\u8d27\u5f02\u5e38, xxlJobRecordCode:{}, integralMallOrderCode:{}, mbrMemberCode:{}", new Object[]{xxlJobRecordCode, integralMallOrderCode, mbrMemberCode, e});
            confirmReceiptRes = new ResponseData(SysResponseEnum.FAILED.getCode(), "\u79ef\u5206\u5546\u57ce\u786e\u8ba4\u6536\u8d27\u5f02\u5e38");
        }
        this.xxlJobRecordDetailService.saveXxlJobRecordDetail(xxlJobRecordCode, (Object)receiptReq, confirmReceiptRes);
        this.xxlJobRecordService.updateHandleCount(xxlJobRecordCode, confirmReceiptRes.getCode() == 0 ? 1 : 0, confirmReceiptRes.getCode() != 0 ? 1 : 0);
        return confirmReceiptRes;
    }

    private ResponseData<Boolean> cancel(String xxlJobRecordCode, String integralMallOrderCode, String mbrMemberCode) {
        IntegralMallOrderCancelReq cancelReq = new IntegralMallOrderCancelReq();
        cancelReq.setIntegralMallOrderCode(integralMallOrderCode);
        cancelReq.setMbrMemberCode(mbrMemberCode);
        cancelReq.setCancelType(IntegralMallOrderStatusOperationTypeEnum.SYSTEM_OPERATION.getType());
        cancelReq.setCancelReason(IntegralMallOrderStatusOperationTypeEnum.SYSTEM_OPERATION.getTypeDes());
        ResponseData cancelRes = new ResponseData(SysResponseEnum.FAILED.getCode(), "\u79ef\u5206\u5546\u57ce\u53d6\u6d88\u8ba2\u5355\u5931\u8d25");
        try {
            cancelRes = this.integralMallOrderFeign.cancel(cancelReq);
            log.info("\u79ef\u5206\u5546\u57ce\u53d6\u6d88\u8ba2\u5355, xxlJobRecordCode:{}, integralMallOrderCode:{}, mbrMemberCode:{}, cancelRes:{}", new Object[]{xxlJobRecordCode, integralMallOrderCode, mbrMemberCode, JacksonUtil.bean2Json((Object)cancelRes)});
        }
        catch (Exception e) {
            log.error("\u79ef\u5206\u5546\u57ce\u53d6\u6d88\u8ba2\u5355\u5f02\u5e38, xxlJobRecordCode:{}, integralMallOrderCode:{}, mbrMemberCode:{}", new Object[]{xxlJobRecordCode, integralMallOrderCode, mbrMemberCode, e});
            cancelRes = new ResponseData(SysResponseEnum.FAILED.getCode(), "\u79ef\u5206\u5546\u57ce\u53d6\u6d88\u8ba2\u5355\u5f02\u5e38");
        }
        this.xxlJobRecordDetailService.saveXxlJobRecordDetail(xxlJobRecordCode, (Object)cancelReq, cancelRes);
        this.xxlJobRecordService.updateHandleCount(xxlJobRecordCode, cancelRes.getCode() == 0 ? 1 : 0, cancelRes.getCode() != 0 ? 1 : 0);
        return cancelRes;
    }
}

