/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.task.center.api.service.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.bizvane.members.feign.model.bo.CouponEntityAddRequestParam;
import com.bizvane.members.feign.model.bo.MbrMemberListRequestParam;
import com.bizvane.members.feign.model.vo.CouponEntityListResponseParam;
import com.bizvane.members.feign.model.vo.MbrGroupDefVO;
import com.bizvane.members.feign.model.vo.MbrMembersVO;
import com.bizvane.members.feign.service.CouponDefFeign;
import com.bizvane.members.feign.service.CouponFeign;
import com.bizvane.members.feign.service.MbrGroupFeign;
import com.bizvane.members.feign.service.MbrMemberFeign;
import com.bizvane.search.feign.model.BO.SearchParam;
import com.bizvane.search.feign.service.SearchFeign;
import com.bizvane.task.center.api.service.common.enums.BatchExecuteStatusEnum;
import com.bizvane.task.center.api.service.common.enums.BatchTaskRecordStatusEnum;
import com.bizvane.task.center.api.service.common.enums.BatchTaskTypeEnum;
import com.bizvane.task.center.domain.config.BusinessNoUtils;
import com.bizvane.task.center.domain.model.entity.BatchTaskPO;
import com.bizvane.task.center.domain.model.entity.BatchTaskRecordPO;
import com.bizvane.task.center.domain.model.entity.CouponManualPO;
import com.bizvane.task.center.domain.service.IBatchTaskRecordService;
import com.bizvane.task.center.domain.service.IBatchTaskService;
import com.bizvane.task.center.domain.service.ICouponManualCouponService;
import com.bizvane.task.center.domain.service.ICouponManualService;
import com.bizvane.task.center.feign.model.bo.BatchTaskAddRequestDTO;
import com.bizvane.task.center.feign.model.bo.CouponManualAddRequestParam;
import com.bizvane.task.center.feign.model.bo.CouponManualCouponAddRequestParam;
import com.bizvane.task.center.feign.model.bo.CouponManualListRequestParam;
import com.bizvane.task.center.feign.model.bo.CouponManualUpdateStatusRequestParam;
import com.bizvane.task.center.feign.model.vo.CouponManualListResponse;
import com.bizvane.utils.enumutils.CouponSendTypeEnum;
import com.bizvane.utils.enumutils.SysOrderByEnum;
import com.bizvane.utils.enumutils.SysResponseEnum;
import com.bizvane.utils.exception.BizException;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CouponManualService {
    private static final Logger log = LoggerFactory.getLogger(CouponManualService.class);
    @Autowired
    private ICouponManualService iCouponManualService;
    @Autowired
    private ICouponManualCouponService iCouponManualCouponService;
    @Autowired
    private IBatchTaskService iBatchTaskService;
    @Autowired
    private IBatchTaskRecordService iBatchTaskRecordService;
    @Autowired
    private CouponFeign couponFeign;
    @Autowired
    private CouponDefFeign couponDefFeign;
    @Autowired
    private MbrMemberFeign mbrMemberFeign;
    @Autowired
    private SearchFeign searchFeign;
    @Autowired
    private MbrGroupFeign mbrGroupFeign;

    @Transactional
    public ResponseData<String> addBatchTask(CouponManualAddRequestParam param) {
        ResponseData createResult = this.iCouponManualService.add(param);
        if (SysResponseEnum.SUCCESS.getCode() != createResult.getCode() || createResult.getData() == null) {
            return new ResponseData(createResult.getCode(), createResult.getMessage());
        }
        String couponManualCode = (String)createResult.getData();
        BatchTaskAddRequestDTO taskParam = BatchTaskAddRequestDTO.builder().businessBatchCode(couponManualCode).taskName(param.getTaskName()).taskType(BatchTaskTypeEnum.SEND_COUPON.getType()).param(JacksonUtil.bean2Json((Object)param)).userCode(param.getUserCode()).userName(param.getUserName()).build();
        String batchTaskCode = this.iBatchTaskService.add(taskParam);
        if (StringUtils.isEmpty((CharSequence)batchTaskCode)) {
            log.error("\u65b0\u589e\u4efb\u52a1\u8bb0\u5f55\u5931\u8d25");
            throw new BizException(-1, "\u521b\u5efa\u901a\u7528\u4efb\u52a1\u5931\u8d25");
        }
        for (CouponManualAddRequestParam.CouponManualCouponDefBO bo : param.getCouponList()) {
            CouponManualCouponAddRequestParam couponAddRequestParam = new CouponManualCouponAddRequestParam();
            couponAddRequestParam.setCouponManualCode(couponManualCode);
            couponAddRequestParam.setCouponDefinitionCode(bo.getCouponDefinitionCode());
            couponAddRequestParam.setCouponDefinitionName(bo.getCouponDefinitionName());
            couponAddRequestParam.setUserCode(param.getUserCode());
            couponAddRequestParam.setUserName(param.getUserName());
            this.iCouponManualCouponService.add(couponAddRequestParam);
        }
        return new ResponseData((Object)couponManualCode);
    }

    public PageInfo<CouponManualListResponse> list(CouponManualListRequestParam param) {
        IPage page = this.iCouponManualService.list(param);
        return new PageInfo((int)page.getCurrent(), (int)page.getSize(), page.getTotal(), page.getRecords());
    }

    public CouponManualListResponse detail(String couponManualCode) {
        String[] couponIds;
        CouponManualListRequestParam param = new CouponManualListRequestParam();
        param.setCouponManualCode(couponManualCode);
        PageInfo page = this.list(param);
        CouponManualListResponse couponManualListResponse = (CouponManualListResponse)page.getList().get(0);
        for (String couponDefinitionCode : couponIds = couponManualListResponse.getCouponDefinitionCodeList().split(",")) {
            couponManualListResponse.getCouponDefinitionVOList().add(this.couponDefFeign.detail(couponDefinitionCode).getData());
        }
        return couponManualListResponse;
    }

    public boolean updateStatus(CouponManualUpdateStatusRequestParam param) {
        return this.iCouponManualService.updateStatus(param);
    }

    public void detailGenerating(BatchTaskPO batchTaskPO) {
        block22: {
            String batchTaskCode = batchTaskPO.getBatchTaskCode();
            String couponManualCode = batchTaskPO.getBusinessBatchCode();
            CouponManualAddRequestParam param = (CouponManualAddRequestParam)JacksonUtil.json2Obj((String)batchTaskPO.getParam(), CouponManualAddRequestParam.class);
            if (param == null) {
                log.error("\u4efb\u52a1\u53c2\u6570\u4e3a\u7a7a:{}", (Object)batchTaskCode);
                return;
            }
            List couponList = param.getCouponList();
            if (Integer.valueOf(0).equals(param.getCouponType())) {
                if (Integer.valueOf(0).equals(param.getMemberConditionType())) {
                    long minId = 0L;
                    block0: while (true) {
                        if (!this.checkStatus(couponManualCode)) {
                            log.info("\u4efb\u52a1\u505c\u7528:{}", (Object)couponManualCode);
                            return;
                        }
                        List mbrMembersVOList = ((PageInfo)this.mbrMemberFeign.list(MbrMemberListRequestParam.builder().pageNum(1).pageSize(1000).minId(Long.valueOf(minId)).orderByEnum(SysOrderByEnum.ASC).build()).getData()).getList();
                        if (CollectionUtils.isEmpty((Collection)mbrMembersVOList)) {
                            log.info("\u5168\u90e8\u4f1a\u5458\u6267\u884c\u5b8c\u6210:{}", (Object)minId);
                            break block22;
                        }
                        minId = ((MbrMembersVO)mbrMembersVOList.get(mbrMembersVOList.size() - 1)).getId();
                        Iterator iterator = mbrMembersVOList.iterator();
                        while (true) {
                            if (!iterator.hasNext()) continue block0;
                            MbrMembersVO mbrMembersVO = (MbrMembersVO)iterator.next();
                            if (null != this.iBatchTaskRecordService.detail(batchTaskCode, mbrMembersVO.getMbrMembersCode())) {
                                log.info("\u91cd\u590d\u660e\u7ec6\u76f4\u63a5\u8df3\u8fc7");
                                continue;
                            }
                            BatchTaskRecordPO recordPO = new BatchTaskRecordPO();
                            recordPO.setBatchTaskRecordCode(BusinessNoUtils.getSystemNo());
                            recordPO.setBatchTaskCode(batchTaskCode);
                            recordPO.setBusinessCode(mbrMembersVO.getMbrMembersCode());
                            recordPO.setBusinessParam(JacksonUtil.bean2Json((Object)mbrMembersVO));
                            recordPO.setStatus(BatchTaskRecordStatusEnum.NEW.getType());
                            recordPO.setCreateUserCode(param.getUserCode());
                            recordPO.setCreateUserName(param.getUserName());
                            recordPO.setCreateDate(LocalDateTime.now());
                            if (!this.iBatchTaskRecordService.save((Object)recordPO)) break block0;
                        }
                        break;
                    }
                    log.info("\u660e\u7ec6\u5199\u5165\u5931\u8d25\uff1a");
                    return;
                }
                if (Integer.valueOf(2).equals(param.getMemberConditionType())) {
                    String mbrGroupDefCode = param.getMbrGroupDefCode();
                    MbrGroupDefVO mbrGroupDefVO = (MbrGroupDefVO)this.mbrGroupFeign.detailDef(mbrGroupDefCode).getData();
                    if (mbrGroupDefVO == null) {
                        log.info("\u5206\u7ec4\u4e0d\u5b58\u5728:{}", (Object)mbrGroupDefCode);
                        return;
                    }
                    long minId = 0L;
                    block2: while (true) {
                        if (!this.checkStatus(couponManualCode)) {
                            log.info("\u4efb\u52a1\u505c\u75282:{}", (Object)couponManualCode);
                            return;
                        }
                        SearchParam searchParam = SearchParam.builder().source("\u6279\u91cf\u53d1\u5238").executeSQL(mbrGroupDefVO.getSql()).queryBatchCode(batchTaskCode).lastMaxID(Long.valueOf(minId)).isPaging(Boolean.valueOf(true)).pageNum(Integer.valueOf(1)).pageSize(Integer.valueOf(1000)).build();
                        ResponseData searchResults = this.searchFeign.groupSearch(searchParam);
                        if (SysResponseEnum.FAILED.getCode() == searchResults.getCode()) {
                            log.info("\u5206\u7ec4\u641c\u7d22\u5931\u8d25:{}", (Object)JacksonUtil.bean2Json((Object)searchResults));
                            return;
                        }
                        List mbrMembersVOList = (List)searchResults.getData();
                        if (CollectionUtils.isEmpty((Collection)mbrMembersVOList)) {
                            log.info("\u4f1a\u5458\u5206\u7ec4\u6267\u884c\u5b8c\u6210:{}", (Object)minId);
                            break block22;
                        }
                        minId = ((MbrMembersVO)mbrMembersVOList.get(mbrMembersVOList.size() - 1)).getId();
                        Iterator iterator = mbrMembersVOList.iterator();
                        while (true) {
                            if (!iterator.hasNext()) continue block2;
                            MbrMembersVO mbrMembersVO = (MbrMembersVO)iterator.next();
                            if (null != this.iBatchTaskRecordService.detail(batchTaskPO.getBusinessBatchCode(), mbrMembersVO.getMbrMembersCode())) {
                                log.info("\u91cd\u590d\u5206\u7ec4\u660e\u7ec6\u76f4\u63a5\u8df3\u8fc7");
                                continue;
                            }
                            BatchTaskRecordPO recordPO = new BatchTaskRecordPO();
                            recordPO.setBatchTaskRecordCode(BusinessNoUtils.getSystemNo());
                            recordPO.setBatchTaskCode(batchTaskCode);
                            recordPO.setBusinessCode(mbrMembersVO.getMbrMembersCode());
                            recordPO.setBusinessParam(JacksonUtil.bean2Json((Object)mbrMembersVO));
                            recordPO.setStatus(BatchTaskRecordStatusEnum.NEW.getType());
                            recordPO.setCreateUserCode(param.getUserCode());
                            recordPO.setCreateUserName(param.getUserName());
                            recordPO.setCreateDate(LocalDateTime.now());
                            if (!this.iBatchTaskRecordService.save((Object)recordPO)) break block2;
                        }
                        break;
                    }
                    log.info("\u5206\u7ec4\u660e\u7ec6\u5199\u5165\u5931\u8d25\uff1a");
                    return;
                }
            } else if (Integer.valueOf(110).equals(param.getCouponType())) {
                CouponManualUpdateStatusRequestParam updateStatusParam = CouponManualUpdateStatusRequestParam.builder().couponManualCode(batchTaskPO.getBusinessBatchCode()).taskStatus(Integer.valueOf(25)).memberCount(param.getMemberCount()).build();
                this.iCouponManualService.updateStatus(updateStatusParam);
                for (int j = 0; j < param.getMemberCount(); ++j) {
                    if (!this.checkStatus(couponManualCode)) {
                        log.info("\u4efb\u52a1\u505c\u75283:{}", (Object)couponManualCode);
                        return;
                    }
                    ArrayList<CouponEntityAddRequestParam.CouponEntityAddDetailRequestParam> couponDefinitionList = new ArrayList<CouponEntityAddRequestParam.CouponEntityAddDetailRequestParam>();
                    for (CouponManualAddRequestParam.CouponManualCouponDefBO couponDefBO : couponList) {
                        CouponEntityAddRequestParam.CouponEntityAddDetailRequestParam addDetailRequestParam = CouponEntityAddRequestParam.CouponEntityAddDetailRequestParam.builder().couponDefinitionCode(couponDefBO.getCouponDefinitionCode()).sendBusinessCode(batchTaskCode).sendBusinessCode2(couponDefBO.getCouponDefinitionCode()).sendBusinessCode3(String.valueOf(j)).build();
                        couponDefinitionList.add(addDetailRequestParam);
                    }
                    CouponEntityAddRequestParam sendRequestParam = CouponEntityAddRequestParam.builder().sendType(CouponSendTypeEnum.BATCH.getType()).couponDefinitionList(couponDefinitionList).userCode(param.getUserCode()).userName(param.getUserName()).build();
                    ResponseData sendCouponResult = this.couponFeign.send(sendRequestParam);
                    if (SysResponseEnum.SUCCESS.getCode() == sendCouponResult.getCode()) {
                        log.info("\u9884\u751f\u6210\u5238\u6210\u529f:{}", (Object)((CouponEntityListResponseParam)((List)sendCouponResult.getData()).get(0)).getCouponNo());
                        continue;
                    }
                    log.info("\u9884\u751f\u6210\u5238\u5931\u8d25:{}", (Object)sendCouponResult.getMessage());
                }
                updateStatusParam = CouponManualUpdateStatusRequestParam.builder().couponManualCode(batchTaskPO.getBusinessBatchCode()).taskStatus(Integer.valueOf(30)).build();
                this.iCouponManualService.updateStatus(updateStatusParam);
                this.iBatchTaskService.updateStatus(batchTaskPO.getBatchTaskCode(), BatchExecuteStatusEnum.COMPLETE.getType());
                return;
            }
        }
        long total = this.iBatchTaskRecordService.page(batchTaskPO.getBatchTaskCode(), null, null, 1, 1).getTotal();
        CouponManualUpdateStatusRequestParam updateStatusParam = CouponManualUpdateStatusRequestParam.builder().couponManualCode(batchTaskPO.getBusinessBatchCode()).taskStatus(Integer.valueOf(25)).memberCount(Integer.valueOf(Long.valueOf(total).intValue())).build();
        this.iCouponManualService.updateStatus(updateStatusParam);
        this.iBatchTaskService.updateStatus(batchTaskPO.getBatchTaskCode(), BatchExecuteStatusEnum.WAIT_EXECUTE_DETAIL.getType());
    }

    public void detailExecuting(BatchTaskPO batchTaskPO) {
        String batchTaskCode = batchTaskPO.getBatchTaskCode();
        CouponManualAddRequestParam param = (CouponManualAddRequestParam)JacksonUtil.json2Obj((String)batchTaskPO.getParam(), CouponManualAddRequestParam.class);
        if (param == null) {
            log.error("1\u4efb\u52a1\u53c2\u6570\u4e3a\u7a7a:{}", (Object)batchTaskPO.getBatchTaskCode());
            return;
        }
        List couponList = param.getCouponList();
        if (Integer.valueOf(0).equals(param.getCouponType())) {
            log.info("\u6807\u51c6\u5238\u53d1\u5238:{}", (Object)JacksonUtil.bean2Json((Object)couponList));
            long minId = 0L;
            block0: while (true) {
                List recordPOList;
                if (CollectionUtils.isEmpty((Collection)(recordPOList = this.iBatchTaskRecordService.page(batchTaskCode, Integer.valueOf(0), Long.valueOf(minId), 1, 1000).getRecords()))) {
                    log.info("\u4efb\u52a1\u660e\u7ec6\u5df2\u6267\u884c\u5b8c\u6210:{}", (Object)minId);
                    break;
                }
                log.info("\u4efb\u52a1\u660e\u7ec6\u67e5\u8be2\u7ed3\u679csize:{}", (Object)recordPOList.size());
                minId = ((BatchTaskRecordPO)recordPOList.get(recordPOList.size() - 1)).getId();
                Iterator iterator = recordPOList.iterator();
                while (true) {
                    int status;
                    if (!iterator.hasNext()) continue block0;
                    BatchTaskRecordPO recordPO = (BatchTaskRecordPO)iterator.next();
                    ArrayList<CouponEntityAddRequestParam.CouponEntityAddDetailRequestParam> couponDefinitionList = new ArrayList<CouponEntityAddRequestParam.CouponEntityAddDetailRequestParam>();
                    for (int j = 0; j < couponList.size(); ++j) {
                        CouponManualAddRequestParam.CouponManualCouponDefBO couponDefBO = (CouponManualAddRequestParam.CouponManualCouponDefBO)couponList.get(j);
                        CouponEntityAddRequestParam.CouponEntityAddDetailRequestParam addDetailRequestParam = CouponEntityAddRequestParam.CouponEntityAddDetailRequestParam.builder().couponDefinitionCode(couponDefBO.getCouponDefinitionCode()).sendBusinessName(batchTaskPO.getTaskName()).sendBusinessCode(batchTaskCode).sendBusinessCode2(recordPO.getBusinessCode()).sendBusinessCode3(String.valueOf(j)).build();
                        couponDefinitionList.add(addDetailRequestParam);
                    }
                    CouponEntityAddRequestParam sendRequestParam = CouponEntityAddRequestParam.builder().mbrMembersCode(recordPO.getBusinessCode()).sendType(CouponSendTypeEnum.BATCH.getType()).couponDefinitionList(couponDefinitionList).userCode(param.getUserCode()).userName(param.getUserName()).build();
                    ResponseData sendCouponResponse = this.couponFeign.send(sendRequestParam);
                    String failDetail = null;
                    if (SysResponseEnum.SUCCESS.getCode() == sendCouponResponse.getCode()) {
                        status = BatchTaskRecordStatusEnum.SUCCESS.getType();
                    } else {
                        status = BatchTaskRecordStatusEnum.FAIL.getType();
                        failDetail = sendCouponResponse.getMessage();
                    }
                    this.iBatchTaskRecordService.updateStatus(batchTaskCode, recordPO.getBusinessCode(), Integer.valueOf(status), failDetail);
                }
                break;
            }
        }
        CouponManualUpdateStatusRequestParam updateStatusParam = CouponManualUpdateStatusRequestParam.builder().couponManualCode(batchTaskPO.getBusinessBatchCode()).taskStatus(Integer.valueOf(30)).build();
        this.iCouponManualService.updateStatus(updateStatusParam);
        this.iBatchTaskService.updateStatus(batchTaskPO.getBatchTaskCode(), BatchExecuteStatusEnum.COMPLETE.getType());
    }

    private boolean checkStatus(String couponManualCode) {
        CouponManualPO po = this.iCouponManualService.detail(couponManualCode);
        return po != null && !Integer.valueOf(35).equals(po.getTaskStatus());
    }
}

