/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.task.center.api.service.jobhandle;

import com.bizvane.task.center.api.service.common.enums.BatchExecuteStatusEnum;
import com.bizvane.task.center.api.service.common.enums.BatchTaskTypeEnum;
import com.bizvane.task.center.api.service.service.CouponExternalService;
import com.bizvane.task.center.api.service.service.CouponManualService;
import com.bizvane.task.center.api.service.service.MbrIntegralBatchService;
import com.bizvane.task.center.api.service.service.MbrLabelService;
import com.bizvane.task.center.domain.model.entity.BatchTaskPO;
import com.bizvane.task.center.domain.service.IBatchTaskService;
import com.bizvane.utils.jacksonutils.JacksonUtil;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BatchTaskJobHandler {
    private static final Logger log = LoggerFactory.getLogger(BatchTaskJobHandler.class);
    @Autowired
    private IBatchTaskService iBatchTaskService;
    @Autowired
    private MbrIntegralBatchService mbrIntegralBatchService;
    @Autowired
    private CouponManualService couponManualService;
    @Autowired
    private CouponExternalService couponExternalService;
    @Autowired
    private MbrLabelService mbrLabelService;

    @XxlJob(value="batchTaskNewJobHandle")
    public void batchTaskNewJobHandle() throws Exception {
        XxlJobHelper.log((String)"batchTaskJobHandle.start", (Object[])new Object[0]);
        List batchTaskPOIPage = this.iBatchTaskService.page(null, BatchExecuteStatusEnum.NEW.getType(), 1, 100, "desc").getRecords();
        if (batchTaskPOIPage.isEmpty()) {
            XxlJobHelper.log((String)"batchTaskJobHandle.end", (Object[])new Object[0]);
            return;
        }
        Collections.reverse(batchTaskPOIPage);
        for (BatchTaskPO batchTaskPO : batchTaskPOIPage) {
            log.info("batchTaskJobHandle.start.batchTaskPO:{}", (Object)JacksonUtil.bean2Json((Object)batchTaskPO));
            try {
                Integer taskType = batchTaskPO.getTaskType();
                if (BatchTaskTypeEnum.SEND_COUPON.getType().equals(taskType)) {
                    this.couponManualService.detailGenerating(batchTaskPO);
                    continue;
                }
                if (BatchTaskTypeEnum.CHANGE_INTEGRAL.getType().equals(taskType)) {
                    this.mbrIntegralBatchService.detailGenerating(batchTaskPO);
                    continue;
                }
                if (BatchTaskTypeEnum.IMPORT_EXTERNAL_COUPON.getType().equals(taskType)) {
                    this.couponExternalService.detailGenerating(batchTaskPO);
                    continue;
                }
                if (!BatchTaskTypeEnum.IMPORT_ADD_LABEL.getType().equals(taskType)) continue;
                this.mbrLabelService.detailGenerating(batchTaskPO);
            }
            catch (Exception e) {
                log.error("batchTaskJobHandle.error.batchTaskPO:{}", (Object)JacksonUtil.bean2Json((Object)batchTaskPO), (Object)e);
            }
        }
    }

    @XxlJob(value="batchTaskExecuteDetailJobHandle")
    public void batchTaskExecuteDetailJobHandle() throws Exception {
        XxlJobHelper.log((String)"batchTaskExecuteDetailJobHandle.start", (Object[])new Object[0]);
        List batchTaskPOIPage = this.iBatchTaskService.page(null, BatchExecuteStatusEnum.WAIT_EXECUTE_DETAIL.getType(), 1, 100, "desc").getRecords();
        if (batchTaskPOIPage.isEmpty()) {
            XxlJobHelper.log((String)"batchTaskExecuteDetailJobHandle.end", (Object[])new Object[0]);
            return;
        }
        Collections.reverse(batchTaskPOIPage);
        for (BatchTaskPO batchTaskPO : batchTaskPOIPage) {
            XxlJobHelper.log((String)"batchTaskExecuteDetailJobHandle.start.batchTaskPO:{}", (Object[])new Object[]{JacksonUtil.bean2Json((Object)batchTaskPO)});
            try {
                Integer taskType = batchTaskPO.getTaskType();
                if (BatchTaskTypeEnum.SEND_COUPON.getType().equals(taskType)) {
                    this.couponManualService.detailExecuting(batchTaskPO);
                    continue;
                }
                if (BatchTaskTypeEnum.CHANGE_INTEGRAL.getType().equals(taskType)) {
                    this.mbrIntegralBatchService.detailExecuting(batchTaskPO);
                    continue;
                }
                if (!BatchTaskTypeEnum.IMPORT_ADD_LABEL.getType().equals(taskType)) continue;
                this.mbrLabelService.detailExecuting(batchTaskPO);
            }
            catch (Exception e) {
                log.error("batchTaskExecuteDetailJobHandle.error.batchTaskPO:{}", (Object)JacksonUtil.bean2Json((Object)batchTaskPO), (Object)e);
            }
        }
    }
}

