/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.sun.common.utils;

import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SpringUtil {
    private static final String configPath = "classpath*:application*.xml";
    private static ClassPathXmlApplicationContext ctx = null;

    public static synchronized <T> T getBean(Class<T> beanCls) {
        if (ctx == null) {
            ctx = new ClassPathXmlApplicationContext(configPath);
            ctx.registerShutdownHook();
        }
        return (T)ctx.getBean(beanCls);
    }

    public static synchronized ClassPathXmlApplicationContext getCtx() {
        if (ctx == null) {
            ctx = new ClassPathXmlApplicationContext(configPath);
            ctx.registerShutdownHook();
        }
        return ctx;
    }

    public static synchronized <T> T getBean(String beanName) {
        if (ctx == null) {
            ctx = new ClassPathXmlApplicationContext(configPath);
            ctx.registerShutdownHook();
        }
        return (T)ctx.getBean(beanName);
    }

    public static synchronized void shutdown() {
        if (ctx != null) {
            ctx.close();
            ctx = null;
        }
    }
}

