/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.sun.common.utils;

import com.bizvane.sun.common.utils.LogUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.Logger;

public class PropertyUtil {
    private final Logger log = LogUtil.getLogger(PropertyUtil.class);
    public static final boolean DEFAULT_USE_CACHE = true;
    private volatile ResourceBundle bundle;
    private String bundleName = null;
    private final ConcurrentMap<String, String> cache = new ConcurrentHashMap<String, String>();
    private boolean useCache = true;
    private String userSubdirectory = "";

    public PropertyUtil(String bundleName) {
        this.bundleName = bundleName;
        this.log.trace("PropertyUtil: bundleName={}", new Object[]{bundleName});
    }

    public PropertyUtil(String bundleName, String userSubdirectory) {
        this(bundleName);
        this.userSubdirectory = userSubdirectory;
    }

    public final void clearPropertyCache() {
        this.cache.clear();
    }

    public String get(String key, String defaultValue) {
        return this.getSystemOrPropertyString(key, defaultValue, this.useCache);
    }

    public String getPropertyBundleName() {
        return this.bundleName;
    }

    public String getSystemOrPropertyString(String key, String defaultValue, boolean useCache) {
        String putIfAbsent;
        ResourceBundle nextBundle;
        if (useCache && this.cache.containsKey(key)) {
            return (String)this.cache.get(key);
        }
        String result = System.getProperty(key);
        if (result == null && (nextBundle = this.getBundle()) != null) {
            try {
                result = nextBundle.getString(key);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (result == null) {
            result = defaultValue;
        }
        if (useCache && result != null && (putIfAbsent = this.cache.putIfAbsent(key, result)) != null && !putIfAbsent.equals(result)) {
            this.cache.put(key, result);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Returning property value: <{}>=<{}> (default=<{}>)", new Object[]{key, result, defaultValue});
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPropertyBundleName(String newPropertyBundleName) {
        Objects.requireNonNull(newPropertyBundleName, "Property bundle name cannot be null");
        this.bundleName = newPropertyBundleName;
        this.log.trace("PropertyUtil: change bundleName={}", new Object[]{this.bundleName});
        this.cache.clear();
        PropertyUtil propertyUtil = this;
        synchronized (propertyUtil) {
            this.bundle = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceBundle getBundle() {
        ResourceBundle result = this.bundle;
        if (result == null) {
            PropertyUtil propertyUtil = this;
            synchronized (propertyUtil) {
                URLClassLoader loader;
                URL[] urls;
                result = this.bundle;
                if (result == null) {
                    String userDir = System.getProperty("user.dir");
                    if (userDir != null) {
                        String fullUserDir = userDir.endsWith("/") ? userDir + this.userSubdirectory : userDir + "/" + this.userSubdirectory;
                        this.log.debug("Looking for property bundle in user.dir + subdirectory: {}", new Object[]{fullUserDir});
                        Path userDirPath = Paths.get(fullUserDir, new String[0]);
                        if (Files.exists(userDirPath, new LinkOption[0])) {
                            try {
                                urls = new URL[]{userDirPath.toUri().toURL()};
                                loader = new URLClassLoader(urls);
                                result = ResourceBundle.getBundle(this.bundleName, Locale.getDefault(), loader, ResourceBundle.Control.getNoFallbackControl(ResourceBundle.Control.FORMAT_PROPERTIES));
                                this.log.debug("Found property bundle in user.dir + subdirectory: {} {}", new Object[]{userDirPath.toUri().toURL(), this.bundleName});
                            }
                            catch (MalformedURLException e) {
                                this.log.debug("URL exception with user.dir:", (Throwable)e);
                            }
                            catch (MissingResourceException e) {
                                this.log.debug("Missing resource exception with user.dir:", (Throwable)e);
                            }
                        }
                    } else {
                        this.log.debug("Could not find user.dir property");
                    }
                }
                if (result == null) {
                    String userHome = System.getProperty("user.home");
                    if (userHome != null) {
                        String fullUserHome = userHome.endsWith("/") ? userHome + this.userSubdirectory : userHome + "/" + this.userSubdirectory;
                        this.log.debug("Looking for property bundle in user.home + subdirectory: {}", new Object[]{fullUserHome});
                        Path userHomePath = Paths.get(fullUserHome, new String[0]);
                        if (Files.exists(userHomePath, new LinkOption[0])) {
                            try {
                                urls = new URL[]{userHomePath.toUri().toURL()};
                                loader = new URLClassLoader(urls);
                                result = ResourceBundle.getBundle(this.bundleName, Locale.getDefault(), loader, ResourceBundle.Control.getNoFallbackControl(ResourceBundle.Control.FORMAT_PROPERTIES));
                                this.log.debug("Found property bundle in user.home + subdirectory: {} {}", new Object[]{userHomePath.toUri().toURL(), this.bundleName});
                            }
                            catch (MalformedURLException e) {
                                this.log.debug("URL exception with user.home:", (Throwable)e);
                            }
                            catch (MissingResourceException e) {
                                this.log.debug("Missing resource exception with user.home:", (Throwable)e);
                            }
                        }
                    } else {
                        this.log.debug("Could not find user.home property");
                    }
                }
                if (result == null) {
                    try {
                        this.log.debug("Looking for property bundle on classpath");
                        result = ResourceBundle.getBundle(this.bundleName);
                        this.log.debug("Found property bundle in classpath: {}", new Object[]{this.bundleName});
                    }
                    catch (MissingResourceException missingResourceException) {
                        // empty catch block
                    }
                }
                if (result == null) {
                    this.log.info("Could not find property bundle: {}", new Object[]{this.bundleName});
                }
                this.bundle = result;
            }
        }
        return result;
    }
}

