/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.sun.common.utils;

public class CharsetUtil {
    public static String gbk2UTF8(String gbk) {
        String l_temp = CharsetUtil.gbk2Unicode(gbk);
        l_temp = CharsetUtil.unicodeToUTF8(l_temp);
        return l_temp;
    }

    public static String utf82GBK(String utf) {
        String l_temp = CharsetUtil.utf8ToUnicode(utf);
        l_temp = CharsetUtil.unicode2GBK(l_temp);
        return l_temp;
    }

    public static String gbk2Unicode(String str) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            char chr1 = str.charAt(i);
            if (!CharsetUtil.isNeedConvert(chr1)) {
                result.append(chr1);
                continue;
            }
            result.append("\\u" + Integer.toHexString(chr1));
        }
        return result.toString();
    }

    public static String unicode2GBK(String str) {
        int index = 0;
        StringBuffer buffer = new StringBuffer();
        int li_len = str.length();
        while (index < li_len) {
            if (index >= li_len - 1 || !"\\u".equals(str.substring(index, index + 2))) {
                buffer.append(str.charAt(index));
                ++index;
                continue;
            }
            String charStr = "";
            charStr = str.substring(index + 2, index + 6);
            char letter = (char)Integer.parseInt(charStr, 16);
            buffer.append(letter);
            index += 6;
        }
        return buffer.toString();
    }

    public static boolean isNeedConvert(char para) {
        return (para & 0xFF) != para;
    }

    public static String getEncoding(String str) {
        String encode = "GB2312";
        try {
            if (str.equals(new String(str.getBytes(encode), encode))) {
                String s = encode;
                return s;
            }
        }
        catch (Exception s) {
            // empty catch block
        }
        encode = "ISO-8859-1";
        try {
            if (str.equals(new String(str.getBytes(encode), encode))) {
                String s1 = encode;
                return s1;
            }
        }
        catch (Exception s1) {
            // empty catch block
        }
        encode = "UTF-8";
        try {
            if (str.equals(new String(str.getBytes(encode), encode))) {
                String s2 = encode;
                return s2;
            }
        }
        catch (Exception s2) {
            // empty catch block
        }
        encode = "GBK";
        try {
            if (str.equals(new String(str.getBytes(encode), encode))) {
                String s3 = encode;
                return s3;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public static String utf8ToUnicode(String inStr) {
        char[] myBuffer = inStr.toCharArray();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < inStr.length(); ++i) {
            Character.UnicodeBlock ub = Character.UnicodeBlock.of(myBuffer[i]);
            if (ub == Character.UnicodeBlock.BASIC_LATIN) {
                sb.append(myBuffer[i]);
                continue;
            }
            if (ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS) {
                int j = myBuffer[i] - 65248;
                sb.append((char)j);
                continue;
            }
            short s = (short)myBuffer[i];
            String hexS = Integer.toHexString(s);
            String unicode = "\\u" + hexS;
            sb.append(unicode.toLowerCase());
        }
        return sb.toString();
    }

    public static String unicodeToUTF8(String theString) {
        int len = theString.length();
        StringBuffer outBuffer = new StringBuffer(len);
        int x = 0;
        while (x < len) {
            int aChar;
            if ((aChar = theString.charAt(x++)) == 92) {
                if ((aChar = theString.charAt(x++)) == 117) {
                    int value = 0;
                    block6: for (int i = 0; i < 4; ++i) {
                        aChar = theString.charAt(x++);
                        switch (aChar) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                value = (value << 4) + aChar - 48;
                                continue block6;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                value = (value << 4) + 10 + aChar - 97;
                                continue block6;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                value = (value << 4) + 10 + aChar - 65;
                                continue block6;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed   \\uxxxx   encoding.");
                            }
                        }
                    }
                    outBuffer.append((char)value);
                    continue;
                }
                if (aChar == 116) {
                    aChar = 9;
                } else if (aChar == 114) {
                    aChar = 13;
                } else if (aChar == 110) {
                    aChar = 10;
                } else if (aChar == 102) {
                    aChar = 12;
                }
                outBuffer.append((char)aChar);
                continue;
            }
            outBuffer.append((char)aChar);
        }
        return outBuffer.toString();
    }
}

