/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.sun.common.service.redis;

import com.bizvane.sun.common.utils.LogUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Logger;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import redis.clients.jedis.Jedis;

public class RedisClient {
    private static Logger logger = LogUtil.getLogger(RedisClient.class);
    private RedisTemplate<Serializable, Object> redisTemplate;

    public void remove(String ... keys) {
        for (String key : keys) {
            this.remove(key);
        }
    }

    public void removePattern(String pattern) {
        Set keys = this.redisTemplate.keys((Object)pattern);
        if (keys.size() > 0) {
            this.redisTemplate.delete((Collection)keys);
        }
    }

    public void remove(String key) {
        if (this.exists(key)) {
            this.redisTemplate.delete((Object)key);
        }
    }

    public boolean exists(String key) {
        return this.redisTemplate.hasKey((Object)key);
    }

    public Object get(String key) {
        Object result = null;
        ValueOperations operations = this.redisTemplate.opsForValue();
        result = operations.get((Object)key);
        return result;
    }

    public boolean set(String key, Object value) {
        boolean result = false;
        try {
            ValueOperations operations = this.redisTemplate.opsForValue();
            operations.set((Object)key, value);
            result = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public boolean set(String key, Object value, Long expireTime) {
        boolean result = false;
        try {
            ValueOperations operations = this.redisTemplate.opsForValue();
            operations.set((Object)key, value);
            this.redisTemplate.expire((Object)key, expireTime.longValue(), TimeUnit.SECONDS);
            result = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public void setRedisTemplate(RedisTemplate<Serializable, Object> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public static void main(String[] args) {
        Jedis jedis = new Jedis("dev.bizvane.com");
        jedis.auth("Bizvane-redis-password");
        System.out.println("Connection to server sucessfully");
        jedis.set("w3ckey", "Redis tutorial");
        System.out.println("Stored string in redis:: " + jedis.keys("123*"));
    }
}

