/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.sun.common.service.hbase;

import com.bizvane.sun.common.utils.LogUtil;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class HBaseClient {
    static Logger logger = LogUtil.getLogger(HBaseClient.class);
    static Configuration conf = null;
    static Connection connection = null;

    public static void creatTable(String tableName, String[] family) throws Exception {
        Admin admin = connection.getAdmin();
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf((String)tableName));
        for (int i = 0; i < family.length; ++i) {
            desc.addFamily(new HColumnDescriptor(family[i]));
        }
        if (admin.tableExists(TableName.valueOf((String)tableName))) {
            logger.info("Table exists");
            return;
        }
        admin.createTable(desc);
        logger.info("Create table success");
    }

    public static void addData(String rowKey, String tableName, String[] column1, String[] value1, String[] column2, String[] value2) throws IOException {
        Put put = new Put(Bytes.toBytes((String)rowKey));
        Table table = connection.getTable(TableName.valueOf((String)tableName));
        HColumnDescriptor[] columnFamilies = table.getTableDescriptor().getColumnFamilies();
        for (int i = 0; i < columnFamilies.length; ++i) {
            int j;
            String familyName = columnFamilies[i].getNameAsString();
            if (familyName.equals("article")) {
                for (j = 0; j < column1.length; ++j) {
                    put.addColumn(Bytes.toBytes((String)familyName), Bytes.toBytes((String)column1[j]), Bytes.toBytes((String)value1[j]));
                }
            }
            if (!familyName.equals("author")) continue;
            for (j = 0; j < column2.length; ++j) {
                put.addColumn(Bytes.toBytes((String)familyName), Bytes.toBytes((String)column2[j]), Bytes.toBytes((String)value2[j]));
            }
        }
        table.put(put);
        logger.info("Add data success");
    }

    public static String getResult(String tableName, String rowKey) throws IOException {
        Get get = new Get(Bytes.toBytes((String)rowKey));
        Table table = connection.getTable(TableName.valueOf((String)tableName));
        Result result = table.get(get);
        String results = "";
        if (result.list() != null && result.list().size() > 0) {
            for (KeyValue kv : result.list()) {
                results = Bytes.toString((byte[])kv.getValue());
            }
        }
        return results;
    }

    public static Result getResultValue(String tableName, String rowKey) throws IOException {
        Get get = new Get(Bytes.toBytes((String)rowKey));
        Table table = connection.getTable(TableName.valueOf((String)tableName));
        Result result = table.get(get);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getResultScanner(String tableName) throws IOException {
        Scan scan = new Scan();
        Table table = connection.getTable(TableName.valueOf((String)tableName));
        try (ResultScanner rs = null;){
            rs = table.getScanner(scan);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<Result> getResultList(String tableName) throws IOException {
        Scan scan = new Scan();
        ResultScanner rs = null;
        ArrayList<Result> resultArrayList = new ArrayList<Result>();
        Table table = connection.getTable(TableName.valueOf((String)tableName));
        try {
            rs = table.getScanner(scan);
            for (Result r : rs) {
                resultArrayList.add(r);
            }
        }
        finally {
            rs.close();
            return resultArrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getResultScanner(String tableName, String start_rowkey, String stop_rowkey) throws IOException {
        Scan scan = new Scan();
        scan.setStartRow(Bytes.toBytes((String)start_rowkey));
        scan.setStopRow(Bytes.toBytes((String)stop_rowkey));
        Table table = connection.getTable(TableName.valueOf((String)tableName));
        try (ResultScanner rs = null;){
            rs = table.getScanner(scan);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<Result> getResultList(String tableName, String start_rowkey, String stop_rowkey) throws IOException {
        Scan scan = new Scan();
        scan.setStartRow(Bytes.toBytes((String)start_rowkey));
        scan.setStopRow(Bytes.toBytes((String)stop_rowkey));
        ResultScanner rs = null;
        ArrayList<Result> resultArrayList = new ArrayList<Result>();
        Table table = connection.getTable(TableName.valueOf((String)tableName));
        try {
            rs = table.getScanner(scan);
            for (Result r : rs) {
                resultArrayList.add(r);
            }
        }
        finally {
            rs.close();
            return resultArrayList;
        }
    }

    public static Result getResultByColumn(String tableName, String rowKey, String familyName, String columnName) throws IOException {
        Table table = connection.getTable(TableName.valueOf((String)tableName));
        Get get = new Get(Bytes.toBytes((String)rowKey));
        get.addColumn(Bytes.toBytes((String)familyName), Bytes.toBytes((String)columnName));
        Result result = table.get(get);
        return result;
    }

    public static void updateTable(String tableName, String rowKey, String familyName, String columnName, String value) throws IOException {
        Table table = connection.getTable(TableName.valueOf((String)tableName));
        Put put = new Put(Bytes.toBytes((String)rowKey));
        put.addColumn(Bytes.toBytes((String)familyName), Bytes.toBytes((String)columnName), Bytes.toBytes((String)value));
        table.put(put);
        logger.info("Update table success!");
    }

    public static Result getResultByVersion(String tableName, String rowKey, String familyName, String columnName) throws IOException {
        Table table = connection.getTable(TableName.valueOf((String)tableName));
        Get get = new Get(Bytes.toBytes((String)rowKey));
        get.addColumn(Bytes.toBytes((String)familyName), Bytes.toBytes((String)columnName));
        get.setMaxVersions(5);
        Result result = table.get(get);
        return result;
    }

    public static void deleteColumn(String tableName, String rowKey, String falilyName, String columnName) throws IOException {
        Table table = connection.getTable(TableName.valueOf((String)tableName));
        Delete deleteColumn = new Delete(Bytes.toBytes((String)rowKey));
        deleteColumn.deleteColumns(Bytes.toBytes((String)falilyName), Bytes.toBytes((String)columnName));
        table.delete(deleteColumn);
        logger.info(falilyName + ":" + columnName + " is deleted");
    }

    public static void deleteAllColumn(String tableName, String rowKey) throws IOException {
        Table table = connection.getTable(TableName.valueOf((String)tableName));
        Delete deleteAll = new Delete(Bytes.toBytes((String)rowKey));
        table.delete(deleteAll);
        logger.info("All columns are deleted");
    }

    public static void deleteTable(String tableName) throws IOException {
        Admin admin = connection.getAdmin();
        admin.disableTable(TableName.valueOf((String)tableName));
        admin.deleteTable(TableName.valueOf((String)tableName));
        logger.info(tableName + " is deleted!");
    }

    static {
        conf = HBaseConfiguration.create();
        conf.set("hbase.master", "m1:16000");
        conf.set("hbase.superuser", "hbase");
        conf.set("hbase.rpc.protection", "authentication");
        conf.set("zookeeper.znode.parent", "/hbase-unsecure");
        conf.set("hbase.zookeeper.property.clientPort", "2181");
        conf.set("hbase.zookeeper.quorum", "s2,s3,s4,s5,s6,s7,s8,s9,s10,s11,s13,s14,s15,s16,s12");
        try {
            UserGroupInformation.setConfiguration((Configuration)conf);
            UserGroupInformation userGroupInformation = UserGroupInformation.createRemoteUser((String)"hbase");
            UserGroupInformation.setLoginUser((UserGroupInformation)userGroupInformation);
            connection = ConnectionFactory.createConnection((Configuration)conf);
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            e.printStackTrace();
        }
    }
}

