/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.sun.common.service.flume;

import com.bizvane.sun.common.utils.LogUtil;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.flume.Event;
import org.apache.flume.EventDeliveryException;
import org.apache.flume.api.RpcClient;
import org.apache.flume.api.RpcClientFactory;
import org.apache.flume.event.EventBuilder;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class FlumeClient {
    private RpcClient client;
    private String hostname;
    private int port;
    Logger logger = LogUtil.getLogger(FlumeClient.class);

    FlumeClient() {
    }

    public FlumeClient(String hostname, int port) {
        this.hostname = hostname;
        this.port = port;
        this.client = RpcClientFactory.getDefaultInstance((String)hostname, (Integer)port);
    }

    public FlumeClient(String address) {
        String[] add = address.split(":");
        this.hostname = add[0];
        this.port = Integer.valueOf(add[1]);
        this.client = RpcClientFactory.getDefaultInstance((String)this.hostname, (Integer)this.port);
    }

    public RpcClient getRpcClient() {
        return RpcClientFactory.getDefaultInstance((String)this.hostname, (Integer)this.port);
    }

    public void Push(HashMap<String, String> headers, LinkedList<String> datalist) {
        try {
            for (String data : datalist) {
                Event event = EventBuilder.withBody((String)data, (Charset)Charset.forName("UTF-8"));
                if (headers != null && headers.size() >= 1) {
                    event.setHeaders(headers);
                }
                this.client.append(event);
            }
        }
        catch (EventDeliveryException e) {
            this.client.close();
            this.client = null;
            this.client = RpcClientFactory.getDefaultInstance((String)this.hostname, (Integer)this.port);
            this.logger.error(e.getMessage());
            e.printStackTrace();
        }
    }

    public void PushBatch(List<Event> dataEventlist) {
        try {
            this.client.appendBatch(dataEventlist);
        }
        catch (EventDeliveryException e) {
            this.client.close();
            this.client = null;
            this.client = RpcClientFactory.getDefaultInstance((String)this.hostname, (Integer)this.port);
            this.logger.error(e.getMessage());
            e.printStackTrace();
        }
    }

    public void cleanUp() {
        this.client.close();
    }
}

