/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.sun.common.method;

import com.bizvane.sun.common.method.Method;
import com.bizvane.sun.common.utils.LogUtil;
import com.bizvane.sun.common.utils.PackageUtil;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Logger;

public class Factory {
    private static final Logger logger = LogUtil.getLogger(Factory.class);
    private static Map<String, Method> methodMap = null;

    public static Map<String, Method> getMethodMap(String packageName) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        List<String> classNames = PackageUtil.getClassName(packageName);
        if (classNames != null && methodMap != null) {
            for (String className : classNames) {
                String[] nodes = className.split("/");
                String sampleClassName = nodes[nodes.length - 1];
                String classTail = sampleClassName.substring(sampleClassName.length() - 6, sampleClassName.length());
                if (!classTail.equals("Method")) continue;
                String methodName = sampleClassName.replace("Method", "");
                Method method = (Method)Class.forName(sampleClassName).newInstance();
                methodMap.put(methodName, method);
                logger.info("Added method: " + methodName + " <" + method.toString() + ">");
            }
            return methodMap;
        }
        return null;
    }
}

