/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.sun.common.ice.server;

import Ice.DispatchInterceptor;
import Ice.DispatchStatus;
import Ice.Identity;
import Ice.Object;
import Ice.Request;
import com.bizvane.sun.common.utils.LogUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.Logger;

public class PerfDispatchInterceptor
extends DispatchInterceptor {
    private static Logger logger = LogUtil.getLogger(PerfDispatchInterceptor.class);
    private static final Map<Identity, Object> id2ObjectMap = new ConcurrentHashMap<Identity, Object>();
    private static final PerfDispatchInterceptor self = new PerfDispatchInterceptor();
    private static final long serialVersionUID = 1L;

    public static PerfDispatchInterceptor getInstance() {
        return self;
    }

    public static DispatchInterceptor addICEObject(Identity id, Object iceObj) {
        id2ObjectMap.put(id, iceObj);
        return self;
    }

    public DispatchStatus dispatch(Request request) {
        Identity theId = request.getCurrent().id;
        String inf = "Dispach req, method:" + request.getCurrent().operation + " service:" + theId.name + " server address:" + request.getCurrent().con;
        logger.info(inf + " begin");
        try {
            DispatchStatus reslt = id2ObjectMap.get(request.getCurrent().id).ice_dispatch(request);
            logger.info(inf + " success");
            return reslt;
        }
        catch (RuntimeException e) {
            logger.info(inf + " error " + e);
            throw e;
        }
    }

    public static void removeICEObject(Identity id) {
        logger.info("Remove ice object " + id);
        id2ObjectMap.remove(id);
    }
}

