/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.sun.common.ice.server;

import Ice.Communicator;
import Ice.DispatchInterceptor;
import Ice.Identity;
import Ice.Logger;
import Ice.Object;
import Ice.ObjectAdapter;
import Ice.Util;
import IceBox.Service;
import com.bizvane.sun.common.ice.server.Log4jLogerI;
import com.bizvane.sun.common.ice.server.PerfDispatchInterceptor;
import com.bizvane.sun.common.utils.LogUtil;
import java.util.Arrays;

public abstract class AbstractIceBoxService
implements Service {
    protected ObjectAdapter _adapter;
    protected Identity id;
    protected static org.apache.logging.log4j.Logger logger = LogUtil.getLogger(AbstractIceBoxService.class);
    protected static Log4jLogerI iceLogger = new Log4jLogerI("ice_communicator");

    public void start(String name, Communicator communicator, String[] args) {
        Util.setProcessLogger((Logger)iceLogger);
        this._adapter = communicator.createObjectAdapter(name);
        Object object = this.createIceServiceObject(args);
        this.id = communicator.stringToIdentity(name);
        DispatchInterceptor interceptor = PerfDispatchInterceptor.addICEObject(this.id, object);
        this._adapter.add((Object)interceptor, this.id);
        this.addIceServiceObjFacets(this._adapter, this.id);
        this._adapter.activate();
        logger.info(name + "service started, with param size " + args.length + " detail: " + Arrays.toString(args));
    }

    protected abstract void addIceServiceObjFacets(ObjectAdapter var1, Identity var2);

    public abstract Object createIceServiceObject(String[] var1);

    public void stop() {
        logger.info("Stopping service " + this.id + " ....");
        this._adapter.destroy();
        PerfDispatchInterceptor.removeICEObject(this.id);
        logger.info("Service " + this.id + " stoped");
    }
}

