/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.sun.common.ice.client;

import Ice.Communicator;
import Ice.ObjectPrx;
import Ice.Util;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class ICEClientUtil {
    private static volatile Communicator ic = null;
    private static Map<Class, ObjectPrx> cls2PrxMap = new HashMap<Class, ObjectPrx>();
    private static volatile long lastAccessTimestamp;
    private static volatile MonitorThread nonitorThread;
    private static long idleTimeOutSeconds;
    private static String iceLocator;
    private static final String locatorKey = "--Ice.Default.Locator";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static Communicator getICECommunictor() {
        if (ic == null) {
            Class<ICEClientUtil> clazz = ICEClientUtil.class;
            // MONITORENTER : com.bizvane.sun.common.ice.client.ICEClientUtil.class
            if (ic == null) {
                if (iceLocator == null) {
                    iceLocator = "MyIceGrid/Locator:tcp -h 127.0.0.1 -p 4061";
                }
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                System.out.println(sdf.format(new Date()) + "\tIce client's locator is " + iceLocator + " proxy cache time out seconds :" + idleTimeOutSeconds);
                String[] initParams = new String[]{"--Ice.Default.Locator=" + iceLocator};
                ic = Util.initialize((String[])initParams);
                ICEClientUtil.createMonitorThread();
            }
            // MONITOREXIT : clazz
        }
        lastAccessTimestamp = System.currentTimeMillis();
        return ic;
    }

    private static void createMonitorThread() {
        nonitorThread = new MonitorThread();
        nonitorThread.setDaemon(true);
        nonitorThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeCommunicator(boolean removeServiceCache) {
        Class<ICEClientUtil> clazz = ICEClientUtil.class;
        synchronized (ICEClientUtil.class) {
            if (ic != null) {
                ICEClientUtil.safeShutdown();
                nonitorThread.interrupt();
                if (removeServiceCache && !cls2PrxMap.isEmpty()) {
                    try {
                        cls2PrxMap.clear();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static void safeShutdown() {
        try {
            ic.shutdown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            ic.destroy();
            ic = null;
        }
    }

    public static ObjectPrx getSerivcePrx(Communicator communicator, Class serviceCls, String version) {
        return ICEClientUtil.createIceProxy(communicator, serviceCls, version);
    }

    private static ObjectPrx createIceProxy(Communicator communicator, Class serviceCls, String Version) {
        ObjectPrx proxy = null;
        String clsName = serviceCls.getName();
        String serviceName = serviceCls.getSimpleName();
        int pos = serviceName.lastIndexOf("Prx");
        if (pos <= 0) {
            throw new IllegalArgumentException("Invalid ObjectPrx class ,class name must end with Prx");
        }
        String realSvName = serviceName.substring(0, pos);
        try {
            ObjectPrx base = communicator.stringToProxy(realSvName);
            proxy = (ObjectPrx)Class.forName(clsName + "Helper").newInstance();
            Method m1 = proxy.getClass().getDeclaredMethod("checkedCast", ObjectPrx.class, String.class);
            proxy = (ObjectPrx)m1.invoke((Object)proxy, base, Version == null ? null : Version.toUpperCase());
            return proxy;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static ObjectPrx getSerivcePrx(Class serviceCls) {
        return ICEClientUtil.getSerivcePrx(serviceCls, null);
    }

    public static ObjectPrx getSerivcePrx(Class serviceCls, String Version) {
        ObjectPrx proxy = cls2PrxMap.get(serviceCls);
        if (proxy != null) {
            lastAccessTimestamp = System.currentTimeMillis();
            return proxy;
        }
        proxy = ICEClientUtil.createIceProxy(ICEClientUtil.getICECommunictor(), serviceCls, Version);
        cls2PrxMap.put(serviceCls, proxy);
        lastAccessTimestamp = System.currentTimeMillis();
        return proxy;
    }

    private void setIceLocator(String iceLocator) {
        ICEClientUtil.iceLocator = iceLocator;
    }

    private void setIdleTimeOutSeconds(long idleTimeOutSeconds) {
        ICEClientUtil.idleTimeOutSeconds = idleTimeOutSeconds;
    }

    static {
        idleTimeOutSeconds = 0L;
        iceLocator = null;
    }

    static class MonitorThread
    extends Thread {
        MonitorThread() {
        }

        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    Thread.sleep(5000L);
                    if (lastAccessTimestamp + idleTimeOutSeconds * 1000L >= System.currentTimeMillis()) continue;
                    ICEClientUtil.closeCommunicator(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

