package com.bizvane.rights.vo.staffbenefit;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

@Data
public class QueryStaffBenefitTypeRespVO {

    @ApiModelProperty("员工福利类型系统code")
    private String mktStaffBenefitTypeCode;

    @ApiModelProperty("分类名称")
    private String typeName;

    @ApiModelProperty("分类编号")
    private String typeNo;

    @ApiModelProperty("排序")
    private Integer sort;

    @ApiModelProperty("类型描述")
    private String typeDesc;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("版本号")
    private Integer version;

    @ApiModelProperty("创建时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createDate;

    @ApiModelProperty("创建人编号")
    private String createUserCode;

    @ApiModelProperty("创建人名称")
    private String createUserName;

    @ApiModelProperty("更新时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date modifiedDate;

    @ApiModelProperty("更新人code")
    private String modifiedUserCode;

    @ApiModelProperty("更新人名称")
    private String modifiedUserName;

    @ApiModelProperty("数据有效性")
    private Boolean valid;
}
