package com.bizvane.rights.vo.staffbenefit;

import com.bizvane.rights.vo.PageVO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

@Data
public class QueryStaffBenefitPageReqVO extends PageVO {

    @ApiModelProperty("福利名称")
    private String benefitName;

    @ApiModelProperty("投放开始时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date openStartTime;

    @ApiModelProperty("投放结束时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date openEndTime;

    @ApiModelProperty("创建人名称")
    private String createUserName;

    @ApiModelProperty("创建开始时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createStartDate;

    @ApiModelProperty("创建结束时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createEndDate;

    @ApiModelProperty(value = "状态 0待上架 1上架中 2已下架 3已结束")
    private Integer state;

}
