package com.bizvane.rights.vo.parking.luggage;

import com.bizvane.rights.consts.BusinessConst;
import com.bizvane.rights.vo.OptUserVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.time.LocalDateTime;

@Data
public class RightsLuggageDoorToDoorSaveRequestVO extends OptUserVO implements Serializable {

    @ApiModelProperty("会员code")
    private String mbrMembersCode;

    @ApiModelProperty("商户编号")
    private String merchantNo;

    @ApiModelProperty("预约记录编号")
    private String reservationRecordNo;

    @ApiModelProperty("预约类型, 1=当日达, 2=约定达")
    private Integer appointmentType;

    @ApiModelProperty("预约点位")
    private String appointmentLocation;

    @ApiModelProperty("寄件人姓名")
    private String senderName;

    @ApiModelProperty("寄件人手机号, 敏感信息SM4加密后传输")
    private String senderPhone;

    @ApiModelProperty("寄件人手机号加密")
    private String senderPhoneEncrypt;

    @ApiModelProperty("收件人姓名")
    private String recipientName;

    @ApiModelProperty("收件人手机号, 敏感信息SM4加密后传输")
    private String recipientPhone;

    @ApiModelProperty("收件人手机号加密")
    private String recipientPhoneEncrypt;

    @ApiModelProperty("所在区")
    private String district;

    @ApiModelProperty("详细地址")
    private String detailedAddress;

    @ApiModelProperty("预约时间")
    @JsonFormat(pattern = BusinessConst.YMDHMS, timezone = BusinessConst.TIMEZONE)
    @DateTimeFormat(pattern = BusinessConst.YMDHMS)
    private LocalDateTime appointmentTime;

    @ApiModelProperty("预约状态, 1=确认中,2=待使用,3=已完成,4=已取消")
    private Integer appointmentStatus;

    @ApiModelProperty("备注")
    private String remark;
}
