package com.bizvane.rights.vo.hotel.roomtype;

import com.bizvane.rights.consts.BusinessConst;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@Data
public class RightsHotelRoomTypeDetailResponseVO implements Serializable {

    @ApiModelProperty("酒店房型code")
    private String rightsHotelRoomTypeCode;

    @ApiModelProperty("酒店主体code")
    private String rightsHotelCode;

    @ApiModelProperty("酒店名称")
    private String hotelName;

    @ApiModelProperty("房型名称")
    private String roomTypeName;

    @ApiModelProperty("房型代码")
    private String roomTypeCode;

    @ApiModelProperty("房型主图(前端传啥存啥)")
    private String roomMainImage;

    @ApiModelProperty("房型其他图片(前端传啥存啥)")
    private String roomOtherImage;

    @ApiModelProperty("房型原价")
    private BigDecimal roomOriginalPrice;

    @ApiModelProperty("房型员工优惠价")
    private BigDecimal roomEmployeePrice;

    @ApiModelProperty("房型面积")
    private String roomArea;

    @ApiModelProperty("床型信息")
    private String bedType;

    @ApiModelProperty("房间配置")
    private String roomFacilities;

    @ApiModelProperty("启用状态 true启用/false禁用")
    private Boolean enableStatus;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("创建人code")
    private String createUserCode;

    @ApiModelProperty("创建人")
    private String createUserName;

    @ApiModelProperty("创建日期")
    @JsonFormat(pattern = BusinessConst.YMDHMS, timezone = BusinessConst.TIMEZONE)
    private LocalDateTime createDate;

    @ApiModelProperty("修改人code")
    private String modifiedUserCode;

    @ApiModelProperty("修改人")
    private String modifiedUserName;

    @ApiModelProperty("修改时间")
    @JsonFormat(pattern = BusinessConst.YMDHMS, timezone = BusinessConst.TIMEZONE)
    private LocalDateTime modifiedDate;
}
