package com.bizvane.rights.feign;

import com.bizvane.rights.vo.DisableReqVO;
import com.bizvane.rights.vo.staffbenefit.AddOrUpdateStaffBenefitTypeReqVO;
import com.bizvane.rights.vo.staffbenefit.QueryStaffBenefitTypePageReqVO;
import com.bizvane.rights.vo.staffbenefit.QueryStaffBenefitTypeRespVO;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * <p>
 * 员工福利类型 前端控制器
 * </p>
 *
 * @author ciron@zhidemai.com
 * @since 2024-11-11
 */
@FeignClient(value = "${feign.client.rights.name}", path = "${feign.client.rights.path}/tMktStaffBenefitType")
public interface TMktStaffBenefitTypeFeign {

    @PostMapping("/saveOrUpdate")
    ResponseData<String> saveOrUpdateType(@RequestBody AddOrUpdateStaffBenefitTypeReqVO reqVO);

    @GetMapping("/getDetail")
    ResponseData<QueryStaffBenefitTypeRespVO> getDetail(@RequestParam("mktStaffBenefitTypeCode") String mktStaffBenefitTypeCode);

    @PostMapping("/pageList")
    ResponseData<List<QueryStaffBenefitTypeRespVO>> pageList(@RequestBody QueryStaffBenefitTypePageReqVO reqVO);

    @PostMapping("/delete")
    ResponseData<String> delete(@RequestBody DisableReqVO reqVO);

}
