package com.bizvane.rights.feign;

import com.bizvane.rights.vo.steward.StatusReqVO;
import com.bizvane.rights.vo.steward.StewardQueryReqVO;
import com.bizvane.rights.vo.steward.StewardServiceDescriptionReqRespVO;
import com.bizvane.rights.vo.steward.StewardServiceReqRespVO;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

@Api(value = "管家服务记录", tags = "管家服务记录")
@FeignClient(value = "${feign.client.rights.name}", path = "${feign.client.rights.path}/stewardService")
public interface StewardServiceFeign {
    @ApiOperation(value = "保存管家服务记录", notes = "保存特管家服务记录", httpMethod = "POST")
    @PostMapping("addOrUpdate")
    ResponseData<Boolean> addOrUpdate(@RequestBody StewardServiceReqRespVO requestVO);
    @ApiOperation(value = "保存管家服务启用禁用", notes = "保存管家服务启用禁用", httpMethod = "POST")
    @PostMapping("/changeStatus")
    public ResponseData<Boolean> changeStatus(@RequestBody StatusReqVO requestVO);
    @ApiOperation(value = "保存管家服务介绍", notes = "保存管家服务介绍", httpMethod = "POST")
    @PostMapping("/saveDescription")
    public ResponseData<Boolean> saveDescription(@RequestBody StewardServiceDescriptionReqRespVO requestVO);
    @ApiOperation(value = "获取列表")
    @PostMapping("/pageList")
    public ResponseData<PageInfo<StewardServiceReqRespVO>> pageList(@RequestBody StewardQueryReqVO stewardServiceVO);
    @ApiOperation(value ="获取管家服务介绍")
    @PostMapping("/detailDescription")
    public ResponseData<StewardServiceDescriptionReqRespVO> detailDescription();
    @ApiOperation(value ="获取管家服务明细")
    @PostMapping("/detailService")
    public ResponseData<StewardServiceReqRespVO> detailService(StatusReqVO statusReqVO);
    }
