package com.bizvane.rights.vo.hotel.roomtype;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.web.bind.annotation.RequestParam;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

@Data
public class RightsHotelRoomTypeConditionRequestVO implements Serializable {

    @ApiModelProperty("房型名称")
    private String roomTypeName;

    @ApiModelProperty("启用状态 true启用/false禁用")
    private Boolean enableStatus;

    @ApiModelProperty("创建人")
    private String createUserName;

    @ApiModelProperty("创建日期-开始")
    private LocalDateTime createDateStart;

    @ApiModelProperty("创建日期-结束")
    private LocalDateTime createDateEnd;

    @ApiModelProperty("修改人")
    private String modifiedUserName;

    @ApiModelProperty("修改时间-开始")
    private LocalDateTime modifiedDateStart;

    @ApiModelProperty("修改时间-结束")
    private LocalDateTime modifiedDateEnd;

    @ApiModelProperty("酒店主体code")
    private String rightsHotelCode;

    @ApiModelProperty("组织code列表")
    private List<String> orgCodeList;
}
