package com.bizvane.rights.feign;

import com.bizvane.rights.vo.hotel.roomtype.*;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 酒店房型feign
 *
 * @author liuying
 */
@Api(value = "酒店房型", tags = "酒店房型")
@FeignClient(value = "${feign.client.rights.name}", path = "${feign.client.rights.path}/hotelRoomType")
public interface HotelRoomTypeFeign {

    /**
     * 1.条件查询房型列表,无需分页
     * 2.查询房型明细
     * 3.新增房型
     * 4.修改房型
     * 5.禁用房型
     */

    @ApiOperation(value = "code查询酒店房型详情", notes = "code查询酒店房型详情", httpMethod = "GET")
    @GetMapping("detailByCode")
    ResponseData<RightsHotelRoomTypeDetailResponseVO> detail(@RequestParam("rightsHotelRoomTypeCode") String rightsHotelRoomTypeCode);

    @ApiOperation(value = "酒店房型查询列表,无需分页", notes = "酒店房型查询列表,无需分页", httpMethod = "GET")
    @PostMapping("listByCondition")
    ResponseData<List<RightsHotelRoomTypeDetailResponseVO>> listByCondition(@RequestBody RightsHotelRoomTypeConditionRequestVO requestVO);

    @ApiOperation(value = "房型酒店新增", notes = "房型酒店新增", httpMethod = "POST")
    @PostMapping("add")
    ResponseData<RightsHotelRoomTypeAddResponseVO> add(@RequestBody RightsHotelRoomTypeAddRequestVO requestVO);

    @ApiOperation(value = "修改酒店房型", notes = "修改酒店房型", httpMethod = "POST")
    @PostMapping("update")
    ResponseData<RightsHotelRoomTypeUpdateResponseVO> update(@RequestBody RightsHotelRoomTypeUpdateRequestVO requestVO);

    @ApiOperation(value = "禁用酒店房型", notes = "禁用酒店房型", httpMethod = "POST")
    @PostMapping("disable")
    ResponseData<RightsHotelRoomTypeDisableResponseVO> updateEnableStatus(@RequestBody RightsHotelRoomTypeDisableRequestVO requestVO);

    @ApiOperation(value = "酒店房型二级接口", notes = "酒店房型二级接口", httpMethod = "GET")
    @GetMapping("listHotelWithRoomType")
    ResponseData<List<RightsHotelWithRoomTypeVO>> listHotelWithRoomType(@RequestParam("orgCodeList") List<String> orgCodeList);
}
