package com.bizvane.rights.feign;

import com.bizvane.rights.vo.hotel.order.mobile.*;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 酒店订单mobile feign接口
 * @author liuying
 */
@Api(value = "酒店订单mobile", tags = "酒店订单mobile")
@FeignClient(value = "${feign.client.rights.name}", path = "${feign.client.rights.path}/hotelOrderMobile")
public interface HotelOrderMobileFeign {

    /**
     * 1.预下单
     * 2.提交订单
     * 3.取消订单
     * 4.查询订单信息
     */
    @ApiOperation(value = "预下单", notes = "预下单", httpMethod = "POST")
    @PostMapping("preOrder")
    ResponseData<RightsHotelPreOrderResponseVO> preOrder(@RequestBody RightsHotelPreOrderRequestVO requestVO);

    @ApiOperation(value = "下单", notes = "下单", httpMethod = "POST")
    @PostMapping("order")
    ResponseData<RightsHotelOrderResponseVO> order(@RequestBody RightsHotelOrderRequestVO requestVO);

    @ApiOperation(value = "订单支付(微信)", notes = "订单支付", httpMethod = "POST")
    @PostMapping("orderPayment")
    ResponseData<RightsHotelOrderPaymentResponseVO> orderPayment(@RequestBody RightsHotelOrderPaymentRequestVO requestVO);

    @ApiOperation(value = "订单取消", notes = "订单取消", httpMethod = "POST")
    @PostMapping("orderCancel")
    ResponseData<RightsHotelOrderCancelResponseVO> orderCancel(@RequestBody RightsHotelOrderCancelRequestVO requestVO);

    @ApiOperation(value = "订单详情", notes = "订单详情", httpMethod = "POST")
    @PostMapping("orderDetail")
    ResponseData<RightsHotelOrderDetailResponseVO> orderDetail(@RequestBody RightsHotelOrderDetailRequestVO requestVO);
}
