package com.bizvane.rights.feign.mobile;

import com.bizvane.rights.vo.OptStatusVO;
import com.bizvane.rights.vo.transit.benefits.mobile.TransitBenefitsMobileQueryRequestVO;
import com.bizvane.rights.vo.transit.benefits.mobile.TransitBenefitsMobileQueryResponseVO;
import com.bizvane.rights.vo.transit.guide.TransitGuideVO;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@FeignClient(value = "${feign.client.rights.name}", path = "${feign.client.rights.path}/transitBenefitsMobile")
public interface TransitBenefitsMobileFeign {

    @ApiOperation(value = "1.查询行程信息/生成行程信息", notes = "查询行程信息/生成行程信息", httpMethod = "POST")
    @PostMapping("matchFlights")
    ResponseData<String> matchArriveFlights(@RequestBody TransitBenefitsMobileQueryRequestVO requestVO);

    @ApiOperation(value = "2.查询权益信息", notes = "查询权益信息", httpMethod = "POST")
    @PostMapping("getTransferBenefits")
    ResponseData<TransitBenefitsMobileQueryResponseVO> getTransferBenefits(@RequestBody TransitBenefitsMobileQueryRequestVO requestVO);

    @ApiOperation(value = "3.权益领取", notes = "权益领取", httpMethod = "POST")
    @PostMapping("benefitsClaim")
    ResponseData<Boolean> benefitsClaim(@RequestBody TransitBenefitsMobileQueryRequestVO requestVO);
    
    @ApiOperation(value = "查询中转联程指南", notes = "查询中转联程指南", httpMethod = "GET")
    @GetMapping("queryTransitGuide")
    ResponseData<TransitGuideVO> queryTransitGuide();
}
