package com.bizvane.rights.vo.service;

import com.bizvane.rights.consts.BusinessConst;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

@Data
public class RightsSpecialPassengerDetailResponseVO implements Serializable {

    @ApiModelProperty("特殊旅客记录表code")
    private String rightsSpecialPassengerRecordCode;

    @ApiModelProperty("会员code")
    private String mbrMembersCode;

    @ApiModelProperty("商户编号")
    private String merchantNo;

    @ApiModelProperty("预约记录单号")
    private String appointmentRecordNo;

    @ApiModelProperty("服务对象类型, 1=无陪年长旅客, 2=无障碍需求旅客, 3=孕妇旅客, 4=行动不便旅客, 5=无陪怀抱婴儿旅客")
    private Integer serviceTargetType;

    @ApiModelProperty("联系电话, 敏感信息SM4加密后传输")
    private String contactNumber;

    @ApiModelProperty("联系电话加密")
    private String contactNumberEncrypt;

    @ApiModelProperty("是否需要轮椅, true/false")
    private Boolean requiresWheelchair;

    @ApiModelProperty("备注(接口保存)")
    private String remarks;

    @ApiModelProperty("预约时间")
    @JsonFormat(pattern = BusinessConst.YMDHMS, timezone = BusinessConst.TIMEZONE)
    private LocalDateTime appointmentTime;

    @ApiModelProperty("预约状态, 1=确认中,2=待使用,3=已完成,4=已取消")
    private Integer appointmentStatus;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("创建人code")
    private String createUserCode;

    @ApiModelProperty("创建人")
    private String createUserName;

    @ApiModelProperty("创建日期")
    @JsonFormat(pattern = BusinessConst.YMDHMS, timezone = BusinessConst.TIMEZONE)
    private LocalDateTime createDate;

    @ApiModelProperty("修改人code")
    private String modifiedUserCode;

    @ApiModelProperty("修改人")
    private String modifiedUserName;

    @ApiModelProperty("修改时间")
    @JsonFormat(pattern = BusinessConst.YMDHMS, timezone = BusinessConst.TIMEZONE)
    private LocalDateTime modifiedDate;

    @ApiModelProperty("航班信息")
    private RightsSpecialPassengerFlightDetailVO flightDetail;

    @ApiModelProperty("旅客信息列表")
    private List<RightsSpecialPassengerVO> passengerList;

}
