package com.bizvane.rights.vo.hotel.roomtype;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

@Data
@NoArgsConstructor
public class RightsHotelWithRoomTypeVO implements Serializable {

    @ApiModelProperty("酒店主体code")
    private String rightsHotelCode;

    @ApiModelProperty("酒店名称")
    private String hotelName;

    @ApiModelProperty("酒店编码")
    private String hotelCode;

    @ApiModelProperty("酒店房型List")
    private List<RoomTypeVO> roomTypeVOList;

    @Data
    public static class RoomTypeVO implements Serializable {

        @ApiModelProperty("酒店房型code")
        private String rightsHotelRoomTypeCode;

        @ApiModelProperty("房型名称")
        private String roomTypeName;

        @ApiModelProperty("房型代码")
        private String roomTypeCode;
    }
}
