package com.bizvane.rights.enums;

import lombok.Getter;

@Getter
public enum TransitTypeEnum {

    ARRIVE(2,"到达"),
    TRANSFER(1,"中转")

    ;
    private Integer type;

    private String desc;

    TransitTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static TransitTypeEnum typeOf(Integer type) {
        for (TransitTypeEnum value : TransitTypeEnum.values()) {
            if (value.getType().equals(type)) {
                return value;
            }
        }
        return null;
    }
}
