package com.bizvane.rights.vo.steward;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

@Data
public class StewardServiceByFlightIdentityAndDateMobileRespVo implements Serializable {


    @ApiModelProperty("管家服务信息")
    List<StewardServiceMobileRespVO> services;

    @ApiModelProperty("航班号全称")
    private String flightIdentity;

    @ApiModelProperty("始发机场中文简称")
    private String cnOriginAirport;

    @ApiModelProperty("目的机场中文")
    private String cnDestinationAirport;

    @ApiModelProperty("预计起飞时间")
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private LocalDateTime estimatedTakeOffDateTime;
    @ApiModelProperty("预计落地时间")
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private LocalDateTime estimatedLandingDateTime;

    @ApiModelProperty("取消时间（单位：小时，最小输入1最大24）")
    private Integer endCancelTime;




}
