package com.bizvane.rights.feign;

import com.bizvane.rights.vo.DisableReqVO;
import com.bizvane.rights.vo.UpdateShelfStatusReqVO;
import com.bizvane.rights.vo.UpdateSortReqVO;
import com.bizvane.rights.vo.staffbenefit.AddOrUpdateStaffBenefitReqVO;
import com.bizvane.rights.vo.staffbenefit.QueryStaffBenefitDetailRespVO;
import com.bizvane.rights.vo.staffbenefit.QueryStaffBenefitPageReqVO;
import com.bizvane.rights.vo.staffbenefit.UpdateStaffBenefitCheckStatusReqVO;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * <p>
 * 员工福利 前端控制器
 * </p>
 *
 * @author ciron@zhidemai.com
 * @since 2024-11-11
 */
@FeignClient(value = "${feign.client.rights.name}", path = "${feign.client.rights.path}/tMktStaffBenefit")
public interface TMktStaffBenefitFeign {

    @PostMapping("/saveOrUpdate")
    ResponseData<String> saveOrUpdate(@RequestBody AddOrUpdateStaffBenefitReqVO reqVO);

    @GetMapping("/getDetail")
    ResponseData<QueryStaffBenefitDetailRespVO> getDetail(@RequestParam("mktStaffBenefitCode") String mktStaffBenefitCode);

    @PostMapping("/pageList")
    ResponseData<PageInfo<QueryStaffBenefitDetailRespVO>> pageList(@RequestBody QueryStaffBenefitPageReqVO reqVO);

    @PostMapping("/updateUpState")
    ResponseData<String> updateUpState(@RequestBody UpdateShelfStatusReqVO reqVO);

    @PostMapping("/updateSort")
    ResponseData<String> updateSort(@RequestBody UpdateSortReqVO reqVO);

    @PostMapping("/disable")
    ResponseData<String> disable(@RequestBody DisableReqVO reqVO);

    @ApiOperation(value = "员工福利-审核回调")
    @PostMapping("/updateCheckStatus")
    ResponseData<String> updateCheckStatus(@RequestBody UpdateStaffBenefitCheckStatusReqVO reqVO);
}
