package com.bizvane.rights.vo.service;

import com.bizvane.rights.vo.OptUserVO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

@Data
public class RightsServiceRecordAddRequestVO extends OptUserVO implements Serializable {

    @ApiModelProperty("会员code")
    private String mbrMembersCode;

    @ApiModelProperty("商户编号")
    private String merchantNo;

    @ApiModelProperty("服务类型1.特殊旅客服务  2.无障碍车位预约  3.行李门到门服务")
    private Integer serviceType;

    @ApiModelProperty("服务code")
    private String serviceCode;

    @ApiModelProperty("预约记录编号")
    private String reservationRecordNo;

    @ApiModelProperty("预约状态, 1=确认中,2=待使用,3=已完成,4=已取消")
    private Integer appointmentStatus;

    @ApiModelProperty("预约地点")
    private String appointmentLocation;

    @ApiModelProperty("预约时间")
    private LocalDateTime appointmentTime;

    @ApiModelProperty("服务对象类型,1-19 特殊旅客服务 20-29 无障碍车位预约 30-39 行李门到门 1=无陪年长旅客, 2=无障碍需求旅客, 3=孕妇旅客, 4=行动不便旅客, 5=无陪怀抱婴儿旅客")
    private Integer serviceTargetType;
}
