package com.bizvane.rights.vo.hotel.order;

import com.bizvane.rights.consts.BusinessConst;
import com.bizvane.rights.vo.PageVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.web.bind.annotation.RequestParam;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

@Data
public class RightsHotelOrderInfoPageRequestVO extends PageVO implements Serializable {

    @ApiModelProperty("订单编号")
    private String orderNo;

    @ApiModelProperty("订单状态 1.待确认 2.已确认 3.已入住 4.已取消 5.待支付 6.退款中")
    private Integer orderStatus;

    @ApiModelProperty("酒店房型code")
    private String rightsHotelRoomTypeCode;

    @ApiModelProperty("预定姓名")
    private String reservationName;

    @ApiModelProperty("入住时间(实际是预计到店时间)-开始")
    private LocalDateTime checkInTimeStart;

    @ApiModelProperty("入住时间(实际是预计到店时间)-结束")
    private LocalDateTime checkInTimeEnd;

    @ApiModelProperty("预定时间-开始")
    private LocalDateTime reservationTimeStart;

    @ApiModelProperty("预定时间-结束")
    private LocalDateTime reservationTimeEnd;

    @ApiModelProperty("是否评价：1=未评价；2=已评价")
    private Integer evaluationStatus;

    @ApiModelProperty("标签type 1.待确认 2.已确认 3.已入住 4.已取消 5.待支付 6.退款中")
    private Integer labelType;

    @ApiModelProperty("组织codeList")
    private List<String> orgCodeList;

    @ApiModelProperty("支付状态 1.入住时支付 2.微信支付")
    private Integer payType;

    @ApiModelProperty("预定类型 1.员工预定 2.会员预定")
    private Integer reservationType;
}
